<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::latest()->paginate(10);
        return view('admin.categories.index', compact('categories'));
    }

    public function create()
    {
        return view('admin.categories.create');
    }

   public function store(Request $request)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'slug' => 'nullable|string|max:255',
        'image' => 'nullable|image|max:4096',
    ]);

    $data = $request->only(['name', 'slug']);

    // Upload Image
    if ($request->hasFile('image')) {
        $filename = time() . '_' . uniqid() . '.' . $request->image->extension();
        $request->image->move(public_path('uploads/categories'), $filename);
        $data['image'] = $filename;
    }

    // Default status if not provided
    $data['status'] = 'active';

    Category::create($data);

    return back()->with('success', 'Category created successfully.');
}


   public function update(Request $request, Category $category)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'slug' => 'nullable|string|max:255',
        'image' => 'nullable|image|max:4096',
    ]);

    $data = $request->only(['name', 'slug', 'status']);

    // If new image uploaded
    if ($request->hasFile('image')) {

        // Delete old if exists
        if ($category->image && file_exists(public_path('uploads/categories/' . $category->image))) {
            unlink(public_path('uploads/categories/' . $category->image));
        }

        $filename = time() . '_' . uniqid() . '.' . $request->image->extension();
        $request->image->move(public_path('uploads/categories'), $filename);

        $data['image'] = $filename;
    }

    $category->update($data);

    return back()->with('success', 'Category updated successfully.');
}


    public function destroy(Category $category)
    {
        $category->delete();
        return redirect()->route('admin.categories.index')
            ->with('success', 'Category deleted');
    }
}
