<?php

// app/Http/Controllers/Admin/ContactEnquiryController.php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContactEnquiry;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ContactEnquiryController extends Controller
{
    public function index()
    {
        $enquiries = ContactEnquiry::latest()->paginate(10);
        return view('admin.contact.index', compact('enquiries'));
    }

    /**
     * Header notification feed for latest enquiries.
     */
    public function latest(Request $request)
    {
        $items = ContactEnquiry::query()
            ->latest()
            ->take(8)
            ->get(['id', 'name', 'subject', 'created_at'])
            ->map(function ($enquiry) {
                return [
                    'id' => $enquiry->id,
                    'name' => $enquiry->name,
                    'subject' => Str::limit((string) $enquiry->subject, 40),
                    'time' => $enquiry->created_at?->diffForHumans(),
                    'url' => route('admin.contact.show', $enquiry->id),
                ];
            })
            ->values();

        return response()->json([
            'items' => $items,
        ]);
    }

    public function show(ContactEnquiry $contactEnquiry)
    {
        return view('admin.contact.show', compact('contactEnquiry'));
    }
}
