<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\MediaPresence;

class MediaPresenceController extends Controller
{
    public function index()
    {
        $media = MediaPresence::orderBy('sort_order')->get();
        return view('admin.media.index', compact('media'));
    }

    public function create()
    {
        return view('admin.media.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'image' => 'required|image',
            'sort_order' => 'nullable|integer',
            'status' => 'required',
        ]);

        $data['image'] = $request->file('image')
            ->store('media-presence', 'public');

        MediaPresence::create($data);

        return redirect()->route('admin.media.index')
            ->with('success', 'Media added successfully');
    }

    public function edit(MediaPresence $medium)
    {
        return view('admin.media.edit', compact('medium'));
    }

    public function update(Request $request, MediaPresence $medium)
    {
        $data = $request->validate([
            'image' => 'nullable|image',
            'sort_order' => 'nullable|integer',
            'status' => 'required',
        ]);

        if ($request->hasFile('image')) {
            Storage::disk('public')->delete($medium->image);
            $data['image'] = $request->file('image')
                ->store('media-presence', 'public');
        }

        $medium->update($data);

        return redirect()->route('admin.media.index')
            ->with('success', 'Media updated successfully');
    }

    public function destroy(MediaPresence $medium)
    {
        Storage::disk('public')->delete($medium->image);
        $medium->delete();

        return back()->with('success', 'Media deleted');
    }
}
