<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PopularSearch;
use Illuminate\Http\Request;

class PopularSearchController extends Controller
{
    /* ================= INDEX ================= */
    public function index()
    {
        $searches = PopularSearch::orderBy('sort_order')->get();
        return view('admin.popular-searches.index', compact('searches'));
    }

    /* ================= CREATE ================= */
    public function create()
    {
        return view('admin.popular-searches.create');
    }

    /* ================= STORE ================= */
    public function store(Request $request)
    {
        $request->validate([
            'title'      => 'required|string|max:255',
            'url'        => 'nullable|string|max:255',
            'sort_order' => 'nullable|integer',
            'status'     => 'required|boolean',
        ]);

        PopularSearch::create($request->all());

        return redirect()
            ->route('admin.popular-searches.index')
            ->with('success', 'Popular search added successfully.');
    }

    /* ================= EDIT ================= */
    public function edit(PopularSearch $popular_search)
    {
        return view(
            'admin.popular-searches.edit',
            compact('popular_search')
        );
    }

    /* ================= UPDATE ================= */
    public function update(Request $request, PopularSearch $popular_search)
    {
        $request->validate([
            'title'      => 'required|string|max:255',
            'url'        => 'nullable|string|max:255',
            'sort_order' => 'nullable|integer',
            'status'     => 'required|boolean',
        ]);

        $popular_search->update($request->all());

        return redirect()
            ->route('admin.popular-searches.index')
            ->with('success', 'Popular search updated successfully.');
    }

    /* ================= DELETE ================= */
    public function destroy(PopularSearch $popular_search)
    {
        $popular_search->delete();

        return redirect()
            ->route('admin.popular-searches.index')
            ->with('success', 'Popular search deleted.');
    }
}
