<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Testimonial;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Schema;

class TestimonialController extends Controller
{
    public function index()
    {
        $testimonials = Testimonial::orderBy('sort_order')->get();
        return view('admin.testimonials.index', compact('testimonials'));
    }

    public function create()
    {
        return view('admin.testimonials.create');
    }

    public function store(Request $request)
    {
        $rules = [
            'name' => 'required',
            'message' => 'required',
            'photo' => 'nullable|image',
            'status' => 'boolean',
            'sort_order' => 'integer'
        ];

        if ($this->hasTitleColumn()) {
            $rules['title'] = 'nullable|string|max:255';
        }

        $data = $request->validate($rules);

        if ($request->hasFile('photo')) {
            $data['photo'] = $request->file('photo')->store('testimonials', 'public');
        }

        Testimonial::create($data);

        return redirect()->route('admin.testimonials.index');
    }

    public function edit(Testimonial $testimonial)
    {
        return view('admin.testimonials.edit', compact('testimonial'));
    }

    public function update(Request $request, Testimonial $testimonial)
    {
        $rules = [
            'name' => 'required',
            'message' => 'required',
            'photo' => 'nullable|image',
            'status' => 'boolean',
            'sort_order' => 'integer'
        ];

        if ($this->hasTitleColumn()) {
            $rules['title'] = 'nullable|string|max:255';
        }

        $data = $request->validate($rules);

        if ($request->hasFile('photo')) {
            Storage::disk('public')->delete($testimonial->photo);
            $data['photo'] = $request->file('photo')->store('testimonials', 'public');
        }

        $testimonial->update($data);

        return redirect()->route('admin.testimonials.index');
    }

    public function destroy(Testimonial $testimonial)
    {
        Storage::disk('public')->delete($testimonial->photo);
        $testimonial->delete();
        return back();
    }

    private function hasTitleColumn(): bool
    {
        return Schema::hasColumn('testimonials', 'title');
    }
}
