<?php

namespace App\Http\Controllers\Artist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
public function login()
{
    return view('artist.auth.login');
}



    public function login_submit(Request $request)
    {
        $credentials = $request->only('email', 'password');

        if (Auth::guard('artist')->attempt($credentials)) {
            return redirect()
                ->route('artist.dashboard');
        }

        return back()->with('error', 'Invalid login credentials');
    }

    public function logout()
    {
        Auth::guard('artist')->logout();
        return redirect()->route('artist.login');
    }
}
