<?php

namespace App\Mail;

use App\Models\Artist;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ArtistCredentialsMail extends Mailable
{
    use Queueable, SerializesModels;

    public $artist;
    public $password;

    public function __construct(Artist $artist, $password)
    {
        $this->artist = $artist;
        $this->password = $password;
    }

    public function build()
    {
        return $this->subject('Your Artist Account Login Details')
                    ->view('emails.artist_credentials');
    }
}
