<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Artist extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'artists';

    /**
     * Mass assignable fields
     */
    protected $fillable = [
        'name',
        'slug',
        'username',
        'email',
        'password',        // 🔥 MUST (login के लिए)
        'phone',
        'bio',
        'artwork_image',
        'profile_image',
        'status',
        'updated_by',
        'is_featured',
        'remember_token',
    ];

    /**
     * Hidden fields (security)
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Casts
     */
    protected $casts = [
        'is_featured' => 'boolean',
    ];

    /* =====================
     | RELATIONSHIPS
     ===================== */

    public function paintings()
    {
        return $this->hasMany(Painting::class);
    }

    /* =====================
     | SCOPES
     ===================== */

    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
