<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Form;
use App\Models\Painting;

class Medium extends Model
{
    protected $table = 'mediums';

    protected $fillable = [
        'name',
        'slug',
        'form_id',
        'status',
        'updated_by',
    ];

    /**
     * A medium belongs to one form
     */
    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    /**
     * A medium can have multiple paintings
     */
    public function paintings()
    {
        return $this->hasMany(Painting::class);
    }
}
