<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('hero_sliders', function (Blueprint $table) {
        $table->id();
        $table->string('title');
        $table->text('subtitle')->nullable();
        $table->string('image');
        $table->string('button_text')->nullable();
        $table->string('button_link')->nullable();
        $table->integer('sort_order')->default(0);
        $table->enum('status', ['active','inactive'])->default('active');
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hero_sliders');
    }
};
