<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paintings', function (Blueprint $table) {

            // Painting Code
            $table->string('painting_code')
                  ->nullable()
                  ->after('id');

            // Medium (FK)
            $table->unsignedBigInteger('medium_id')
                  ->nullable()
                  ->after('painting_code');

            // Form (FK)
            $table->unsignedBigInteger('form_id')
                  ->nullable()
                  ->after('medium_id');

            // Foreign Keys
            $table->foreign('medium_id')
                  ->references('id')
                  ->on('mediums')
                  ->nullOnDelete();

            $table->foreign('form_id')
                  ->references('id')
                  ->on('forms')
                  ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paintings', function (Blueprint $table) {

            // Drop FKs first
            $table->dropForeign(['medium_id']);
            $table->dropForeign(['form_id']);

            // Drop columns
            $table->dropColumn([
                'painting_code',
                'medium_id',
                'form_id'
            ]);
        });
    }
};
