<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('about_sections', function (Blueprint $table) {
            $table->id();

            // Banner
            $table->string('banner_image')->nullable();
            $table->string('page_title')->nullable();
            $table->string('breadcrumb_text')->nullable();

            // Welcome section
            $table->string('welcome_title')->nullable();
            $table->string('welcome_subtitle')->nullable();
            $table->text('welcome_description')->nullable();

            // Story section
            $table->string('story_title')->nullable();
            $table->text('story_description')->nullable();
            $table->string('story_image')->nullable();

            // Why choose us
            $table->string('why_1_title')->nullable();
            $table->text('why_1_desc')->nullable();

            $table->string('why_2_title')->nullable();
            $table->text('why_2_desc')->nullable();

            $table->string('why_3_title')->nullable();
            $table->text('why_3_desc')->nullable();

            // Commitment
            $table->string('commitment_title')->nullable();
            $table->text('commitment_description')->nullable();
            $table->string('commitment_image')->nullable();

            // CTA
            $table->string('cta_text')->nullable();
            $table->string('cta_button_text')->nullable();
            $table->string('cta_button_link')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('about_sections');
    }
};
