<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up()
{
    Schema::table('paintings', function (Blueprint $table) {
        $table->decimal('height', 8, 2)->nullable()->after('price');
        $table->decimal('width', 8, 2)->nullable()->after('height');
        $table->boolean('price_on_request')->default(false)->after('width');
    });
}

public function down()
{
    Schema::table('paintings', function (Blueprint $table) {
        $table->dropColumn(['height', 'width', 'price_on_request']);
    });
}

};
