<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('mediums', function (Blueprint $table) {
            $table->unsignedBigInteger('form_id')->nullable()->after('slug');

            // optional but recommended
            $table->foreign('form_id')
                  ->references('id')
                  ->on('forms')
                  ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('mediums', function (Blueprint $table) {
            $table->dropForeign(['form_id']);
            $table->dropColumn('form_id');
        });
    }
};

