<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // 1️⃣ Limit painting_code to 10 characters
        DB::statement('ALTER TABLE paintings MODIFY painting_code VARCHAR(10) NULL');

        Schema::table('paintings', function (Blueprint $table) {
            // 2️⃣ Add slug column if not exists
            if (!Schema::hasColumn('paintings', 'slug')) {
                $table->string('slug', 50)->nullable()->after('painting_code');
            }

            // 3️⃣ Add UNIQUE index on painting_code
            $table->unique('painting_code', 'paintings_painting_code_unique');
        });
    }

    public function down(): void
    {
        Schema::table('paintings', function (Blueprint $table) {
            if (Schema::hasColumn('paintings', 'slug')) {
                $table->dropColumn('slug');
            }

            $table->dropUnique('paintings_painting_code_unique');
        });

        // rollback size
        DB::statement('ALTER TABLE paintings MODIFY painting_code VARCHAR(255) NULL');
    }
};
