<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasColumn('artists', 'updated_by')) {
            Schema::table('artists', function (Blueprint $table) {
                $table->string('updated_by', 100)->nullable()->after('status');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('artists', 'updated_by')) {
            Schema::table('artists', function (Blueprint $table) {
                $table->dropColumn('updated_by');
            });
        }
    }
};
