<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('seo_page_slug_histories', function (Blueprint $table) {
            $table->id();
            // Keep relation with the current SEO page so we can resolve 301 targets.
            $table->foreignId('seo_page_id')->constrained('seo_pages')->cascadeOnDelete();
            // Old slug value is stored without leading slash, e.g. "about-us".
            $table->string('old_slug', 255)->unique();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('seo_page_slug_histories');
    }
};
