<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AboutSection;

class AboutSectionSeeder extends Seeder
{
    public function run(): void
    {
        AboutSection::firstOrCreate(
            ['id' => 1],
            [
                'page_title' => 'About Us',
                'breadcrumb_text' => 'Home \\ About Us',

                'welcome_title' => 'Welcome to Our Gallery',
                'welcome_subtitle' => 'Bringing Art to Life',
                'welcome_description' =>
                    'At our online art gallery, we connect artists with art lovers around the world.',

                'story_title' => 'Our Story',
                'story_description' =>
                    'Founded by art lovers, our mission is to showcase the beauty and emotion of art.',

                'why_1_title' => 'Unique Artwork',
                'why_1_desc' => 'Handpicked original paintings from talented artists.',

                'why_2_title' => 'Worldwide Shipping',
                'why_2_desc' => 'Safe and secure delivery to your door.',

                'why_3_title' => 'Art for Every Space',
                'why_3_desc' => 'A diverse selection to suit every taste and home.',

                'commitment_title' => 'Our Commitment',
                'commitment_description' =>
                    'We are dedicated to providing exceptional art and outstanding service.',

                'cta_text' => 'Explore Our Collection & Find Your Perfect Piece',
                'cta_button_text' => 'Browse Art',
                'cta_button_link' => '/paintings',
            ]
        );
    }
}
