<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SeoPageSeeder extends Seeder
{
    public function run(): void
    {
        $now = now();

        $pages = [
            ['page_key' => 'home', 'seo_title' => 'Home', 'seo_slug' => '/'],
            ['page_key' => 'about', 'seo_title' => 'About', 'seo_slug' => '/about'],
            ['page_key' => 'exclusive', 'seo_title' => 'Exclusive', 'seo_slug' => '/exhibitions'],
            ['page_key' => 'artworks', 'seo_title' => 'Artworks', 'seo_slug' => '/artworks'],
            ['page_key' => 'artists', 'seo_title' => 'Artists', 'seo_slug' => '/artists'],
            ['page_key' => 'blog', 'seo_title' => 'Blog', 'seo_slug' => '/blogs'],
            ['page_key' => 'art_advisory', 'seo_title' => 'Art Advisory', 'seo_slug' => '/art-advisory'],
            ['page_key' => 'contact', 'seo_title' => 'Contact', 'seo_slug' => '/contact'],
        ];

        foreach ($pages as $page) {
            DB::table('seo_pages')->updateOrInsert(
                ['page_key' => $page['page_key']],
                [
                    'seo_title' => $page['seo_title'],
                    'seo_slug' => $page['seo_slug'],
                    'meta_description' => null,
                    'meta_keywords' => null,
                    'updated_at' => $now,
                    'created_at' => $now,
                ]
            );
        }
    }
}
