const isTestEnv = () => {
  // __CtaTestEnv__ is a global variable that is set in the test environment
  // to work around having to use process.env.NODE_ENV in the codebase given
  if (typeof __CtaTestEnv__ == "undefined") {
    // Running in a browser, someone loaded our package.
    return false;
  }

  return __CtaTestEnv__ === "true";
};

class Logger {}

Logger.warn = message => {
  if (isTestEnv()) return;
  console.warn(message);
};

Logger.error = message => {
  if (isTestEnv()) return;
  console.error(message);
};

Logger.info = message => {
  if (isTestEnv()) return;
  console.info(message);
};

Logger.debug = message => {
  if (isTestEnv()) return;
  console.debug(message);
};

Logger.trace = message => {
  if (isTestEnv()) return;
  console.trace(message);
};

const logger = Logger;

export { isTestEnv, logger };
