@extends('admin.layout')

@section('title','Edit Sculpture')

@section('content')
<div class="container-fluid">

    <div class="card shadow-sm">
        <div class="card-header bg-warning">
            <h5 class="mb-0">✏️ Edit Sculpture</h5>
        </div>

        <div class="card-body">

            @if($errors->any())
                <div class="alert alert-danger">
                    @foreach($errors->all() as $error)
                        <div>{{ $error }}</div>
                    @endforeach
                </div>
            @endif

            <form method="POST"
                  action="{{ route('admin.sculptures.update',$sculpture->id) }}"
                  enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="row">

                    <!-- Title -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Title *</label>
                        <input type="text"
                               name="title"
                               class="form-control"
                               value="{{ old('title',$sculpture->title) }}"
                               required>
                    </div>

                    <!-- Price -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Price *</label>
                        <input type="number"
                               name="price"
                               step="0.01"
                               class="form-control"
                               value="{{ old('price',$sculpture->price) }}"
                               required>
                    </div>

                    <!-- Description -->
                    <div class="col-md-12 mb-3">
                        <label class="form-label fw-bold">Description</label>
                        <textarea name="description"
                                  rows="4"
                                  class="form-control">{{ old('description',$sculpture->description) }}</textarea>
                    </div>

                    <!-- Image -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Change Image</label>
                        <input type="file"
                               name="image"
                               class="form-control">
                    </div>

                    <!-- Existing Image -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold d-block">Current Image</label>
                        <img src="{{ asset('uploads/sculptures/'.$sculpture->image) }}"
                             class="img-thumbnail"
                             style="width:150px;">
                    </div>

                </div>

                <div class="mt-4">
                    <button class="btn btn-success px-4">
                        Update Sculpture
                    </button>

                    <a href="{{ route('admin.sculptures.index') }}"
                       class="btn btn-secondary px-4">
                        Back
                    </a>
                </div>

            </form>

        </div>
    </div>

</div>
@endsection
