@extends('admin.layout')

@section('content')
<h4>Sculptures</h4>

<a href="{{ route('admin.sculptures.create') }}" class="btn btn-primary mb-3">
Add Sculpture
</a>

<table class="table table-bordered">
<tr>
<th>Image</th>
<th>Title</th>
<th>Price</th>
<th>Action</th>
</tr>

@foreach($sculptures as $sculpture)
<tr>
<td><img src="{{ asset('uploads/sculptures/'.$sculpture->image) }}" width="60"></td>
<td>{{ $sculpture->title }}</td>
<td>₹ {{ $sculpture->price }}</td>
<td>
<a href="{{ route('admin.sculptures.edit',$sculpture->id) }}" class="btn btn-sm btn-warning">Edit</a>
<form method="POST" action="{{ route('admin.sculptures.destroy',$sculpture->id) }}" class="d-inline">
@csrf @method('DELETE')
<button class="btn btn-sm btn-danger">Delete</button>
</form>
</td>
</tr>
@endforeach
</table>

{{ $sculptures->links() }}
@endsection
