@extends('admin.layout')

@section('content')

<div class="card shadow-sm p-4">

    <h4 class="mb-4">About Creativity Section</h4>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('admin.about-creativity.store') }}" method="POST">
        @csrf

        <!-- TITLE -->
        <div class="mb-3">
            <label class="form-label">Section Title</label>
            <input type="text"
                   name="title"
                   class="form-control"
                   value="{{ old('title', $section->title ?? '') }}"
                   required>
        </div>

        <!-- DESCRIPTION 1 -->
        <div class="mb-3">
            <label class="form-label">Description (Paragraph 1)</label>
            <textarea name="description_1"
                      class="form-control"
                      rows="4"
                      required>{{ old('description_1', $section->description_1 ?? '') }}</textarea>
        </div>

        <!-- DESCRIPTION 2 -->
        <div class="mb-3">
            <label class="form-label">Description (Paragraph 2)</label>
            <textarea name="description_2"
                      class="form-control"
                      rows="4">{{ old('description_2', $section->description_2 ?? '') }}</textarea>
        </div>

        <!-- MEDIA TYPE -->
        <div class="mb-3">
            <label class="form-label">Media Type</label>
            <select name="media_type" class="form-select" required>
                <option value="video"
                    {{ (old('media_type', $section->media_type ?? '') == 'video') ? 'selected' : '' }}>
                    YouTube Video
                </option>
                <option value="image"
                    {{ (old('media_type', $section->media_type ?? '') == 'image') ? 'selected' : '' }}>
                    Image
                </option>
            </select>
        </div>

        <!-- MEDIA URL -->
        <div class="mb-3">
            <label class="form-label">Media URL (YouTube embed OR Image URL)</label>
            <input type="text"
                   name="media_url"
                   class="form-control"
                   placeholder="https://www.youtube.com/embed/xxxx OR /uploads/about.jpg"
                   value="{{ old('media_url', $section->media_url ?? '') }}"
                   required>
        </div>

        <!-- BUTTON TEXT -->
        <div class="mb-3">
            <label class="form-label">Button Text</label>
            <input type="text"
                   name="button_text"
                   class="form-control"
                   value="{{ old('button_text', $section->button_text ?? 'Read More') }}"
                   required>
        </div>

        <!-- BUTTON LINK -->
        <div class="mb-3">
            <label class="form-label">Button Link</label>
            <input type="text"
                   name="button_link"
                   class="form-control"
                   value="{{ old('button_link', $section->button_link ?? '/about') }}"
                   required>
        </div>

        <!-- SAVE -->
        <div class="text-end">
            <button class="btn btn-success px-4">
                Save Changes
            </button>
        </div>

    </form>

</div>

@endsection
