@extends('admin.layout')

@section('content')
<h3>Art Advisory Page</h3>

<form method="POST"
      action="{{ route('admin.art-advisory.update') }}"
      enctype="multipart/form-data">
    @csrf

    <!-- LEFT CONTENT -->
    <div class="mb-3">
        <label class="form-label">Content (Left Side)</label>

        <textarea name="content" id="summernote">
{!! old('content', $advisory->content ?? '') !!}
        </textarea>
    </div>

    <!-- RIGHT IMAGE -->
    <div class="mb-3">
        <label class="form-label">Right Side Image</label><br>

        <input type="file" name="image" class="form-control">

        @if($advisory && $advisory->image)
            <img src="{{ asset('storage/'.$advisory->image) }}"
                 height="120"
                 class="mt-3 rounded border">
        @endif
    </div>

    <button class="btn btn-success px-4">
        Save
    </button>
</form>

@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    if (typeof window.jQuery === 'undefined' || typeof jQuery.fn.summernote === 'undefined') {
        console.error('Summernote dependencies are missing on Art Advisory page.');
        return;
    }

    var $editor = jQuery('#summernote');
    if ($editor.length === 0) return;

    $editor.summernote({
        height: 300,
        placeholder: 'Write Art Advisory content here...'
    });
});
</script>
@endpush
