@extends('admin.layout')

@section('content')

<style>
.artist-form-page {
    --artist-accent: #e6732c;
    --artist-accent-dark: #c95e1f;
    --artist-border: #dce3ef;
}

.artist-form-page .artist-head {
    padding: 1.1rem 1.3rem;
    border-radius: 16px;
    background: linear-gradient(140deg, #fff7ef 0%, #ffffff 58%, #fff3e8 100%);
    border: 1px solid #f3d6bf;
    box-shadow: 0 14px 28px rgba(15, 23, 42, 0.08);
}

.artist-form-page .kicker {
    margin: 0 0 .2rem;
    text-transform: uppercase;
    letter-spacing: .11em;
    font-size: .74rem;
    color: var(--artist-accent);
    font-weight: 700;
}

.artist-form-page .title {
    margin: 0;
    font-size: 1.7rem;
    font-weight: 700;
    color: #1f2937;
}

.artist-form-page .form-card {
    border-radius: 18px;
    border: 1px solid var(--artist-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.artist-form-page .form-body {
    padding: 1.25rem;
}

.artist-form-page label {
    display: block;
    margin-bottom: .4rem;
    font-size: .77rem;
    text-transform: uppercase;
    letter-spacing: .07em;
    color: #526079;
    font-weight: 600;
}

.artist-form-page .form-control,
.artist-form-page textarea {
    width: 100%;
    padding: .62rem .72rem;
    border: 1px solid var(--artist-border);
    border-radius: 10px;
    background: #fff;
    margin-bottom: .9rem;
    transition: all .18s ease;
}

.artist-form-page textarea {
    min-height: 110px;
}

.artist-form-page .form-control:focus,
.artist-form-page textarea:focus {
    outline: none;
    border-color: #ebb488;
    box-shadow: 0 0 0 .2rem rgba(230,115,44,.12);
}

.artist-form-page .url-preview {
    background: #f8fafc;
    color: #475569;
}

.artist-form-page .feature-box {
    border: 1px dashed #f0c3a3;
    background: #fff6ef;
    border-radius: 10px;
    padding: .75rem .9rem;
    margin-bottom: 1rem;
}

.artist-form-page .feature-box small {
    color: #6b7280;
}

.artist-form-page .submit-btn {
    border: none;
    border-radius: 10px;
    padding: .64rem 1.15rem;
    background: linear-gradient(135deg, var(--artist-accent) 0%, #f1984c 100%);
    color: #fff;
    font-weight: 600;
    box-shadow: 0 10px 22px rgba(230,115,44,.28);
}

.artist-form-page .submit-btn:hover {
    background: linear-gradient(135deg, var(--artist-accent-dark) 0%, var(--artist-accent) 100%);
}
</style>

<div class="artist-form-page">
    <div class="artist-head mb-4">
        <p class="kicker">Admin Panel</p>
        <h2 class="title">Create Artist</h2>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            @foreach ($errors->all() as $error)
                <div>{{ $error }}</div>
            @endforeach
        </div>
    @endif

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="form-card">
        <form action="{{ route('admin.artists.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="form-body">
                <label>Name</label>
                <input type="text" name="name" id="artistNameInput" class="form-control" value="{{ old('name') }}" required>

                <label>Artist URL (Slug)</label>
                <input type="text" name="slug" id="artistSlugInput" class="form-control" value="{{ old('slug') }}" placeholder="artist-slug">

                <label>Artist URL Preview</label>
                <input type="text" id="artistUrlPreview" class="form-control url-preview" readonly>

                <label>Updated By</label>
                <input type="text" name="updated_by" class="form-control" value="{{ old('updated_by', optional(Auth::guard('admin')->user())->name) }}">

                <label>Email</label>
                <input type="email" name="email" class="form-control" value="{{ old('email') }}">

                <label>Username</label>
                <input type="text" name="username" class="form-control" value="{{ old('username') }}" required>

                <label>Phone</label>
                <input type="text" name="phone" class="form-control" value="{{ old('phone') }}">

                <label>Bio</label>
                <textarea name="bio">{{ old('bio') }}</textarea>

                <div class="feature-box">
                    <label style="display:flex;align-items:center;gap:8px;margin:0 0 .35rem 0;text-transform:none;letter-spacing:0;font-size:.9rem;color:#111827;">
                        <input type="checkbox" name="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }}>
                        <strong>Mark as Featured Artist</strong>
                    </label>
                    <small>Featured artists appear on home and top of artist listing (Max 10).</small>
                </div>

                <label>Artwork Image (Main Artwork)</label>
                <input type="file" name="artwork_image" class="form-control" required>

                <label>Profile Image (Artist Photo)</label>
                <input type="file" name="profile_image" class="form-control" required>

                <button type="submit" class="submit-btn">Save Artist</button>
            </div>
        </form>
    </div>
</div>

@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    var nameInput = document.getElementById('artistNameInput');
    var slugInput = document.getElementById('artistSlugInput');
    var previewInput = document.getElementById('artistUrlPreview');
    var baseUrl = 'https://www.creativityartgallery.org/artists/';
    var slugTouched = false;

    if (!nameInput || !slugInput || !previewInput) return;

    function slugify(value) {
        return String(value || '')
            .toLowerCase()
            .trim()
            .replace(/[^a-z0-9\s-]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-')
            .replace(/^-|-$/g, '');
    }

    function refreshPreview() {
        var cleaned = slugify(slugInput.value);
        slugInput.value = cleaned;
        previewInput.value = baseUrl + cleaned;
    }

    slugInput.addEventListener('input', function () {
        slugTouched = true;
        refreshPreview();
    });

    nameInput.addEventListener('blur', function () {
        if (!slugTouched && !slugInput.value.trim()) {
            slugInput.value = slugify(nameInput.value);
        }
        refreshPreview();
    });

    refreshPreview();
});
</script>
@endpush
