@extends('admin.layout')

@section('content')

<style>
.artist-admin-page {
    --artist-accent: #e6732c;
    --artist-accent-dark: #ca5f1e;
    --artist-border: #e4e8f1;
    --artist-text: #1f2937;
    --artist-muted: #6b7280;
}

.artist-admin-page .artist-page-head {
    padding: 1.1rem 1.35rem;
    border-radius: 16px;
    background: linear-gradient(140deg, #fff7ef 0%, #ffffff 65%, #fff4ea 100%);
    border: 1px solid #f3d4ba;
    box-shadow: 0 14px 28px rgba(15, 23, 42, 0.08);
}

.artist-admin-page .kicker {
    margin: 0 0 .25rem 0;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .11em;
    color: var(--artist-accent);
    font-weight: 700;
}

.artist-admin-page .page-title {
    margin: 0;
    font-size: 1.7rem;
    color: var(--artist-text);
    font-weight: 700;
}

.artist-admin-page .table-card {
    border-radius: 18px;
    border: 1px solid var(--artist-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.artist-admin-page .table-card-header {
    padding: 1rem 1.2rem;
    border-bottom: 1px solid #edf1f7;
    background: #fbfcff;
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 12px;
}

.artist-admin-page .create-btn {
    border: 0;
    border-radius: 10px;
    padding: .58rem .95rem;
    font-weight: 600;
    font-size: .86rem;
    color: #fff;
    background: linear-gradient(135deg, var(--artist-accent) 0%, #f39a4f 100%);
    text-decoration: none;
    box-shadow: 0 8px 18px rgba(230, 115, 44, 0.28);
}

.artist-admin-page .create-btn:hover {
    background: linear-gradient(135deg, var(--artist-accent-dark) 0%, var(--artist-accent) 100%);
    color: #fff;
}

.artist-admin-page .featured-list-btn {
    border: 1px solid #d7dfeb;
    border-radius: 10px;
    padding: .54rem .85rem;
    font-weight: 600;
    font-size: .84rem;
    color: #1f2937;
    background: #fff;
    text-decoration: none;
}

.artist-admin-page .featured-list-btn:hover {
    background: #f8fafc;
    color: #111827;
}

.artist-admin-page .table-wrap {
    overflow-x: auto;
}

.artist-admin-page table {
    width: 100%;
    border-collapse: collapse;
    min-width: 940px;
}

.artist-admin-page thead th {
    padding: .85rem 1rem;
    font-size: .75rem;
    letter-spacing: .06em;
    text-transform: uppercase;
    color: #5a6880;
    background: #f5f8fd;
    border-bottom: 1px solid #e7edf6;
}

.artist-admin-page tbody td {
    padding: .95rem 1rem;
    border-bottom: 1px solid #edf1f7;
    color: var(--artist-text);
    vertical-align: middle;
}

.artist-admin-page tbody tr:hover {
    background: #fafcff;
}

.artist-admin-page .profile-avatar {
    width: 52px;
    height: 52px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid #f0d8c5;
    box-shadow: 0 6px 16px rgba(15, 23, 42, 0.14);
}

.artist-admin-page .status-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-size: .78rem;
    font-weight: 600;
    padding: .35rem .65rem;
    border-radius: 999px;
}

.artist-admin-page .status-active {
    background: #ecfdf3;
    color: #047857;
    border: 1px solid #9de4c2;
}

.artist-admin-page .status-blocked {
    background: #fef1f1;
    color: #b42318;
    border: 1px solid #f3b0ae;
}

.artist-admin-page .action-list {
    display: flex;
    flex-wrap: wrap;
    gap: 6px;
}

.artist-admin-page .action-btn {
    border: 0;
    border-radius: 8px;
    padding: .36rem .62rem;
    font-size: .74rem;
    color: #fff;
    text-decoration: none;
    cursor: pointer;
}

.artist-admin-page .btn-view { background: #0ea5b7; }
.artist-admin-page .btn-view:hover { background: #0d8c9b; color:#fff; }
.artist-admin-page .btn-edit { background: #2563eb; }
.artist-admin-page .btn-edit:hover { background: #1d4ed8; color:#fff; }

.artist-admin-page .empty-row {
    text-align: center;
    color: var(--artist-muted);
}

.artist-admin-page .artist-success {
    margin: 0 1.2rem 1rem;
    border-radius: 10px;
}

.artist-admin-page .pagination-wrap {
    padding: .9rem 1.2rem 1.1rem;
}

@media (max-width: 768px) {
    .artist-admin-page .table-card-header {
        flex-direction: column;
        align-items: stretch;
    }

    .artist-admin-page .create-btn {
        text-align: center;
    }
}
</style>

<div class="artist-admin-page">
    <div class="artist-page-head mb-4">
        <p class="kicker">Admin Panel</p>
        <h2 class="page-title">Artists Directory</h2>
    </div>

    <div class="table-card">
        <div class="table-card-header">
            <strong style="color:#334155;">All Artists</strong>
            <div style="display:flex;align-items:center;gap:8px;">
                <a href="{{ route('admin.artists.bulk-upload') }}" class="featured-list-btn">Bulk Upload</a>
                <a href="{{ route('admin.artists.bulk-upload.template') }}" class="featured-list-btn">Download Sample</a>
                <a href="{{ route('admin.artists.featured') }}" class="featured-list-btn">View Featured Artists</a>
                <a href="{{ route('admin.artists.create') }}" class="create-btn">+ Create Artist</a>
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success artist-success">
                {{ session('success') }}
            </div>
        @endif

        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th>S.No.</th>
                        <th>Name</th>
                        <th>Profile Photo</th>
                        <th>Artworks Count</th>
                        <th>Updated By</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($artists as $artist)
                    <tr>
                        <td>{{ $artists->firstItem() + $loop->index }}</td>
                        <td>{{ $artist->name }}</td>
                        <td>
                            @if($artist->profile_image)
                                <img src="{{ asset('uploads/artists/'.$artist->profile_image) }}" class="profile-avatar" alt="{{ $artist->name }}">
                            @else
                                -
                            @endif
                        </td>
                        <td>{{ $artist->paintings_count }}</td>
                        <td>{{ $artist->updated_by ?? '-' }}</td>
                        <td>
                            @if($artist->status === 'active')
                                <span class="status-badge status-active">Active</span>
                            @else
                                <span class="status-badge status-blocked">Blocked</span>
                            @endif
                        </td>
                        <td>
                            <div class="action-list">
                                <a href="{{ route('artist.detail', $artist->slug) }}" class="action-btn btn-view">
                                    View
                                </a>

                                <a href="{{ route('admin.artists.edit', $artist) }}" class="action-btn btn-edit">
                                    Edit
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="empty-row">No artists found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="pagination-wrap">
            {{ $artists->links() }}
        </div>
    </div>
</div>

@endsection
