@extends('admin.layout')

@section('content')
<style>
.blog-category-edit .danger-card {
    border: 1px solid #fecaca;
    border-radius: 14px;
    background: #fff5f5;
}

.blog-category-edit .danger-btn {
    border: 0;
    border-radius: 10px;
    padding: .52rem .9rem;
    font-size: .82rem;
    font-weight: 600;
    color: #fff;
    background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%);
}

.blog-category-edit .danger-btn:hover {
    background: linear-gradient(135deg, #b91c1c 0%, #dc2626 100%);
}
</style>

<div class="blog-category-edit">
    <h4 class="mb-3">Edit Blog Category</h4>

    <form method="POST" action="{{ route('admin.blog-categories.update', $blogCategory->id) }}">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label>Category Name</label>
            <input type="text"
                   name="name"
                   class="form-control"
                   value="{{ $blogCategory->name }}"
                   required>
        </div>

        <button type="submit" class="btn btn-primary">Update Category</button>
        <a href="{{ route('admin.blog-categories.index') }}" class="btn btn-secondary">Back</a>
    </form>

    <div class="card danger-card mt-3">
        <div class="card-body d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-2">
            <div>
                <strong class="text-danger">Danger Zone</strong>
                <p class="mb-0 text-muted">Delete this category permanently.</p>
            </div>
            <form method="POST"
                  action="{{ route('admin.blog-categories.destroy', $blogCategory->id) }}"
                  onsubmit="return confirm('Are you sure you want to delete this category?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="danger-btn">Delete Category</button>
            </form>
        </div>
    </div>
</div>
@endsection
