@extends('admin.layout')

@section('content')
<style>
.blog-form-page .page-head {
    padding: 1.15rem 1.3rem;
    border-radius: 16px;
    border: 1px solid #f0d4bf;
    background: linear-gradient(140deg, #fff9f4 0%, #ffffff 68%, #fff3e8 100%);
    box-shadow: 0 14px 30px rgba(15, 23, 42, 0.08);
}

.blog-form-page .kicker {
    margin: 0 0 .25rem;
    font-size: .74rem;
    font-weight: 700;
    letter-spacing: .12em;
    text-transform: uppercase;
    color: #d97706;
}

.blog-form-page .title {
    margin: 0;
    font-size: 1.65rem;
    font-weight: 700;
    color: #1f2937;
}

.blog-form-page .form-card {
    border: 1px solid #e6ebf3;
    border-radius: 16px;
    box-shadow: 0 20px 42px rgba(15, 23, 42, 0.08);
}

.blog-form-page .back-btn {
    border: 1px solid #d6deeb;
    border-radius: 10px;
    padding: .48rem .85rem;
    font-size: .82rem;
    font-weight: 600;
    color: #1f2937;
    text-decoration: none;
    background: #fff;
}

.blog-form-page .back-btn:hover {
    color: #111827;
    background: #f8fafc;
}

.blog-form-page .danger-card {
    border: 1px solid #fecaca;
    border-radius: 16px;
    background: #fff5f5;
}

.blog-form-page .danger-btn {
    border: 0;
    border-radius: 10px;
    padding: .55rem .95rem;
    font-size: .82rem;
    font-weight: 600;
    color: #fff;
    background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%);
}

.blog-form-page .danger-btn:hover {
    background: linear-gradient(135deg, #b91c1c 0%, #dc2626 100%);
}
</style>

<div class="blog-form-page">
    <div class="page-head mb-4 d-flex align-items-center justify-content-between gap-3">
        <div>
            <p class="kicker">Admin Panel</p>
            <h2 class="title">Edit Blog</h2>
        </div>
        <a href="{{ route('admin.blogs.index') }}" class="back-btn">Back to Blogs</a>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0 ps-3">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card form-card">
        <div class="card-body p-4">
            <form action="{{ route('admin.blogs.update', $blog) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                @include('admin.blogs._form')
            </form>
        </div>
    </div>

    <div class="card danger-card mt-3">
        <div class="card-body d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-2">
            <div>
                <strong class="text-danger">Danger Zone</strong>
                <p class="mb-0 text-muted">Delete this blog permanently.</p>
            </div>
            <form action="{{ route('admin.blogs.destroy', $blog) }}" method="POST" onsubmit="return confirm('Delete this blog permanently?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="danger-btn">Delete Blog</button>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@include('admin.blogs.summernote-script')
@endsection
