@extends('admin.layout')

@section('title', 'Edit Category')

@section('content')
<div class="container py-4">

    <h2 class="fw-bold mb-4">Edit Category</h2>

    <form action="{{ route('admin.categories.update', $category) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label fw-semibold">Name</label>
            <input type="text" name="name" value="{{ $category->name }}" class="form-control" required>
        </div>

          <!-- ⭐ New Image Field -->
        <div class="mb-3">
            <label class="form-label fw-semibold">Category Image</label>
            <input type="file" name="image" class="form-control" accept="image/*">

            @if($category->image)
                <div class="mt-2">
                    <p class="fw-semibold">Current Image:</p>
                    <img src="{{ asset('uploads/categories/' . $category->image) }}" 
                         width="120" 
                         class="border rounded">
                </div>
            @endif
        </div>

        <div class="mb-3">
            <label class="form-label fw-semibold">Slug</label>
            <input type="text" name="slug" value="{{ $category->slug }}" class="form-control">
        </div>

        <button class="btn btn-primary">Update</button>
        <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">Cancel</a>
    </form>

</div>
@endsection
