@extends('admin.layout')

@section('content')
<div class="container-fluid">

    <h4 class="fw-bold mb-4">Contact Page Settings</h4>

    <div class="card shadow-sm border-0">
        <div class="card-body">

            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <form method="POST" action="{{ route('admin.contact.settings.update') }}">
                @csrf

                <div class="mb-3">
                    <label class="fw-semibold">Address</label>
                    <textarea name="address" class="form-control" rows="3">
{{ old('address', $setting->address ?? '') }}
                    </textarea>
                </div>

                <div class="mb-3">
                    <label class="fw-semibold">Phone</label>
                    <input type="text" name="phone" class="form-control"
                        value="{{ old('phone', $setting->phone ?? '') }}">
                </div>

                <div class="mb-3">
                    <label class="fw-semibold">Email</label>
                    <input type="email" name="email" class="form-control"
                        value="{{ old('email', $setting->email ?? '') }}">
                </div>

                <div class="mb-3">
                    <label class="fw-semibold">Google Map Embed</label>
                    <textarea name="map_embed" rows="5" class="form-control">
{{ old('map_embed', $setting->map_embed ?? '') }}
                    </textarea>
                </div>

                @if(!empty($setting->map_embed))
                    <div class="mb-4">
                        <label class="fw-semibold">Map Preview</label>
                        <div class="border rounded overflow-hidden" style="height:300px;">
                            {!! $setting->map_embed !!}
                        </div>
                    </div>
                @endif

                <button class="btn btn-primary px-4">Save</button>
            </form>

        </div>
    </div>

</div>
@endsection
