@extends('admin.layout')

@section('content')

<div class="container-fluid">

    <h2 class="mb-4">Edit Exclusive</h2>

    <form method="POST"
          action="{{ route('admin.exhibitions.update', $exhibition->id) }}"
          enctype="multipart/form-data">

        @csrf
        @method('PUT')

        <!-- ================= BASIC DETAILS ================= -->
        <div class="card mb-4">
            <div class="card-body">

                <div class="mb-3">
                    <label class="form-label">Title <span class="text-danger">*</span></label>
                    <input type="text"
                           name="title"
                           class="form-control"
                           value="{{ $exhibition->title }}"
                           required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Venue</label>
                    <input type="text"
                           name="venue"
                           class="form-control"
                           value="{{ $exhibition->venue }}">
                </div>

                <!-- ================= DATE & TIME ================= -->
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Start Date</label>
                        <input type="date"
                               name="event_date"
                               class="form-control"
                               value="{{ $exhibition->event_date }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">End Date</label>
                        <input type="date"
                               name="end_date"
                               class="form-control"
                               value="{{ $exhibition->end_date }}">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Event Time</label>
                    <input type="text"
                           name="event_time"
                           class="form-control"
                           value="{{ $exhibition->event_time }}"
                           placeholder="e.g. 5:00 PM – 9:00 PM">
                </div>

                <!-- ================= META ================= -->
                <div class="mb-3">
                    <label class="form-label">Category</label>
                    <input type="text"
                           name="category"
                           class="form-control"
                           value="{{ $exhibition->category }}">
                </div>

                <div class="mb-3">
                    <label class="form-label">Updated By</label>
                    <input type="text"
                           name="updated_by"
                           class="form-control"
                           value="{{ $exhibition->updated_by }}">
                </div>

                <!-- ================= FEATURED ================= -->
                <div class="form-check mb-3">
                    <input class="form-check-input"
                           type="checkbox"
                           name="is_featured"
                           value="1"
                           id="featuredCheck"
                           {{ $exhibition->is_featured ? 'checked' : '' }}>
                    <label class="form-check-label" for="featuredCheck">
                        Featured Exclusive (Show on Home Page)
                    </label>
                </div>

                <!-- ================= DESCRIPTION ================= -->
                <div class="mb-3">
                    <label class="form-label">Description</label>
                    <textarea name="description"
                              class="form-control"
                              rows="5">{{ $exhibition->description }}</textarea>
                </div>

                <!-- ================= COVER IMAGE ================= -->
                <div class="mb-3">
                    <label class="form-label">Cover Image</label><br>

                    @if($exhibition->cover_image)
                        <img src="{{ asset('storage/'.$exhibition->cover_image) }}"
                             class="rounded mb-2"
                             style="width:180px;height:120px;object-fit:cover;">
                    @endif

                    <input type="file"
                           name="cover_image"
                           class="form-control mt-2">
                </div>

            </div>
        </div>

        <!-- ================= ADD MORE GALLERY IMAGES ================= -->
        <div class="card mb-4">
            <div class="card-body">

                <h5 class="mb-3">Add More Gallery Images</h5>

                <input type="file"
                       name="gallery[]"
                       class="form-control"
                       multiple>

                <small class="text-muted">
                    You can upload multiple images at once
                </small>

            </div>
        </div>

        <!-- ================= ACTION BUTTONS ================= -->
        <button class="btn btn-success px-4">
            Update Exclusive
        </button>

        <a href="{{ route('admin.exhibitions.index') }}"
           class="btn btn-secondary ms-2">
            Back
        </a>

    </form>

    <div class="card mt-4 border-danger-subtle">
        <div class="card-body d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2">
            <div>
                <strong class="text-danger">Danger Zone</strong>
                <p class="mb-0 text-muted">Delete this exclusive permanently.</p>
            </div>
            <form method="POST"
                  action="{{ route('admin.exhibitions.destroy', $exhibition) }}"
                  onsubmit="return confirm('Are you sure you want to delete this exclusive?')">
                @csrf
                @method('DELETE')
                <button class="btn btn-danger">Delete Exclusive</button>
            </form>
        </div>
    </div>

    <!-- ================= EXISTING GALLERY ================= -->
    @if($exhibition->images->count())
        <div class="card mt-5">
            <div class="card-body">

                <h5 class="mb-3">Existing Gallery Images</h5>

                <div class="row g-3">
                    @foreach($exhibition->images as $img)
                        <div class="col-lg-2 col-md-3 col-4 text-center">

                            <img src="{{ asset('storage/'.$img->image) }}"
                                 class="img-fluid rounded mb-2"
                                 style="height:120px;object-fit:cover;">

                            <form method="POST"
                                  action="{{ route('admin.exhibition-images.destroy', $img->id) }}">
                                @csrf
                                @method('DELETE')

                                <button class="btn btn-sm btn-danger">
                                    Delete
                                </button>
                            </form>

                        </div>
                    @endforeach
                </div>

            </div>
        </div>
    @endif

</div>

@endsection
