@extends('admin.layout')

@section('content')
{{-- Categories module UI: Forms tab is the default landing view. --}}
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h3 class="mb-1">Categories</h3>
        <p class="text-muted mb-0">Manage Forms and Mediums used across artworks.</p>
    </div>

    <button class="btn btn-warning text-white" data-bs-toggle="modal" data-bs-target="#createFormModal">
        Add New Form
    </button>
</div>

<ul class="nav nav-tabs mb-3">
    <li class="nav-item">
        <a class="nav-link active" href="{{ route('forms.index') }}">Forms</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" href="{{ route('mediums.index') }}">Mediums</a>
    </li>
</ul>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

@if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

@if($errors->any())
    <div class="alert alert-danger">
        <strong>Please fix the following:</strong>
        <ul class="mb-0 mt-2">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="card shadow-sm border-0">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th class="ps-3">Form</th>
                        <th>Total Artworks</th>
                        <th>Mediums</th>
                        <th>Updated By</th>
                        <th class="text-end pe-3" style="width: 150px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($forms as $form)
                        <tr>
                            <td class="ps-3 fw-semibold">{{ $form->name }}</td>
                            <td>{{ (int) $form->paintings_count }}</td>
                            <td>{{ (int) $form->mediums_count }}</td>
                            <td>{{ $form->updated_by ?: '-' }}</td>
                            <td class="text-end pe-3">
                                <button
                                    class="btn btn-sm btn-outline-primary"
                                    onclick='openEditModal({{ $form->id }}, @json($form->name), @json($form->status))'>
                                    Edit
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            {{-- Empty state copy aligned for forms listing screen. --}}
                            <td colspan="5" class="text-center py-5 text-muted">
                                No forms found. Click <strong>Add New Form</strong> to create your first form.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- Add New Form modal --}}
<div class="modal fade" id="createFormModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="{{ route('forms.store') }}">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Form Name <span class="text-danger">*</span></label>
                        <input
                            type="text"
                            name="name"
                            class="form-control"
                            placeholder="Enter form name"
                            value="{{ old('name') }}"
                            required>
                    </div>

                    <div class="mb-2">
                        <label class="form-label">Status <span class="text-danger">*</span></label>
                        <select name="status" class="form-select" required>
                            <option value="active" {{ old('status', 'active') === 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>

                    <small class="text-muted">Note: Form name must be unique.</small>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning text-white">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- Edit form modal --}}
<div class="modal fade" id="editFormModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="editForm">
            @csrf
            @method('PUT')

            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Form Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="edit_name" class="form-control" placeholder="Enter form name" required>
                    </div>

                    <div>
                        <label class="form-label">Status <span class="text-danger">*</span></label>
                        <select name="status" id="edit_status" class="form-select" required>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <button type="button" class="btn btn-outline-danger" onclick="submitDeleteForm()">Delete</button>

                    <div>
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-warning text-white">Update</button>
                    </div>
                </div>
            </div>
        </form>

        <form method="POST" id="deleteForm" style="display:none;">
            @csrf
            @method('DELETE')
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Shared edit/delete modal wiring for forms table rows.
function openEditModal(id, name, status) {
    document.getElementById('edit_name').value = name;
    document.getElementById('edit_status').value = status;
    document.getElementById('editForm').action = `/admin/forms/${id}`;
    document.getElementById('deleteForm').action = `/admin/forms/${id}`;

    new bootstrap.Modal(document.getElementById('editFormModal')).show();
}

function submitDeleteForm() {
    if (confirm('Delete this form?')) {
        document.getElementById('deleteForm').submit();
    }
}
</script>
@endpush
