@extends('admin.layout')

@section('content')
<h4 class="mb-4 text-capitalize">
    SEO Content for {{ $page }} Page
</h4>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<form method="POST" action="{{ route('admin.page-content.update', $page) }}" enctype="multipart/form-data">
    @csrf

    <ul class="nav nav-tabs mb-3" id="pageContentSeoTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="content-tab" data-bs-toggle="tab" data-bs-target="#content-pane" type="button" role="tab" aria-controls="content-pane" aria-selected="true">
                Content
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="seo-tab" data-bs-toggle="tab" data-bs-target="#seo-pane" type="button" role="tab" aria-controls="seo-pane" aria-selected="false">
                SEO Settings
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pageContentSeoTabsContent">
        <div class="tab-pane fade show active" id="content-pane" role="tabpanel" aria-labelledby="content-tab" tabindex="0">
            <textarea name="content" id="content">
                {!! old('content', $content->content) !!}
            </textarea>
        </div>

        <div class="tab-pane fade" id="seo-pane" role="tabpanel" aria-labelledby="seo-tab" tabindex="0">
            <div class="card">
                <div class="card-header">
                    <strong>SEO Settings</strong>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="seo_title" class="form-label">SEO Title</label>
                            <input
                                type="text"
                                id="seo_title"
                                name="seo_title"
                                class="form-control @error('seo_title') is-invalid @enderror"
                                value="{{ old('seo_title', $seoPage->seo_title) }}"
                                maxlength="60"
                            >
                            @error('seo_title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="seo_slug" class="form-label">SEO Slug</label>
                            <input
                                type="text"
                                id="seo_slug"
                                name="seo_slug"
                                class="form-control @error('seo_slug') is-invalid @enderror"
                                value="{{ old('seo_slug', $seoPage->seo_slug) }}"
                            >
                            @error('seo_slug')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label for="meta_description" class="form-label">Meta Description</label>
                            <textarea
                                id="meta_description"
                                name="meta_description"
                                rows="3"
                                class="form-control @error('meta_description') is-invalid @enderror"
                                maxlength="160"
                            >{{ old('meta_description', $seoPage->meta_description) }}</textarea>
                            @error('meta_description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="meta_title" class="form-label">Meta Title</label>
                            <input
                                type="text"
                                id="meta_title"
                                name="meta_title"
                                class="form-control @error('meta_title') is-invalid @enderror"
                                value="{{ old('meta_title', $seoPage->meta_title) }}"
                            >
                            @error('meta_title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label for="meta_keywords" class="form-label">Meta Keywords</label>
                            <input
                                type="text"
                                id="meta_keywords_input"
                                class="form-control @error('meta_keywords') is-invalid @enderror"
                                placeholder="Type keyword and press Enter or comma"
                                autocomplete="off"
                            >
                            <input
                                type="hidden"
                                id="meta_keywords"
                                name="meta_keywords"
                                value="{{ old('meta_keywords', $seoPage->meta_keywords) }}"
                            >
                            <div id="meta_keywords_tags" class="d-flex flex-wrap gap-2 mt-2"></div>
                            <small class="text-muted d-block mt-1">Maximum 10 keywords.</small>
                            @error('meta_keywords')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="canonical_url" class="form-label">Canonical URL</label>
                            <input
                                type="text"
                                id="canonical_url"
                                name="canonical_url"
                                class="form-control @error('canonical_url') is-invalid @enderror"
                                value="{{ old('canonical_url', $seoPage->canonical_url) }}"
                            >
                            @error('canonical_url')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="meta_robots" class="form-label">Meta Robots</label>
                            <select
                                id="meta_robots"
                                name="meta_robots"
                                class="form-select @error('meta_robots') is-invalid @enderror"
                            >
                                <option value="">Select robots directive</option>
                                @foreach (['index', 'noindex', 'follow', 'nofollow'] as $robot)
                                    <option value="{{ $robot }}" @selected(old('meta_robots', $seoPage->meta_robots) === $robot)>{{ $robot }}</option>
                                @endforeach
                            </select>
                            @error('meta_robots')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <hr>
                            <h6 class="mb-0">Open Graph</h6>
                        </div>

                        <div class="col-md-6">
                            <label for="og_title" class="form-label">OG Title</label>
                            <input
                                type="text"
                                id="og_title"
                                name="og_title"
                                class="form-control @error('og_title') is-invalid @enderror"
                                value="{{ old('og_title', $seoPage->og_title) }}"
                            >
                            @error('og_title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="og_type" class="form-label">OG Type</label>
                            <select
                                id="og_type"
                                name="og_type"
                                class="form-select @error('og_type') is-invalid @enderror"
                            >
                                <option value="">Select OG type</option>
                                @foreach (['website', 'article'] as $ogType)
                                    <option value="{{ $ogType }}" @selected(old('og_type', $seoPage->og_type) === $ogType)>{{ $ogType }}</option>
                                @endforeach
                            </select>
                            @error('og_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label for="og_description" class="form-label">OG Description</label>
                            <textarea
                                id="og_description"
                                name="og_description"
                                rows="3"
                                class="form-control @error('og_description') is-invalid @enderror"
                            >{{ old('og_description', $seoPage->og_description) }}</textarea>
                            @error('og_description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="og_url" class="form-label">OG URL</label>
                            <input
                                type="text"
                                id="og_url"
                                name="og_url"
                                class="form-control @error('og_url') is-invalid @enderror"
                                value="{{ old('og_url', $seoPage->og_url) }}"
                            >
                            @error('og_url')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="og_image" class="form-label">OG Image</label>
                            <input
                                type="file"
                                id="og_image"
                                name="og_image"
                                accept="image/*"
                                class="form-control @error('og_image') is-invalid @enderror"
                            >
                            @if(!empty($seoPage->og_image))
                                <small class="text-muted d-block mt-1">Current: {{ $seoPage->og_image }}</small>
                            @endif
                            @error('og_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <hr>
                            <h6 class="mb-0">Twitter SEO</h6>
                        </div>

                        <div class="col-md-6">
                            <label for="twitter_card" class="form-label">Twitter Card</label>
                            <select
                                id="twitter_card"
                                name="twitter_card"
                                class="form-select @error('twitter_card') is-invalid @enderror"
                            >
                                <option value="">Select twitter card</option>
                                @foreach (['summary', 'summary_large_image'] as $twitterCard)
                                    <option value="{{ $twitterCard }}" @selected(old('twitter_card', $seoPage->twitter_card) === $twitterCard)>{{ $twitterCard }}</option>
                                @endforeach
                            </select>
                            @error('twitter_card')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="twitter_title" class="form-label">Twitter Title</label>
                            <input
                                type="text"
                                id="twitter_title"
                                name="twitter_title"
                                class="form-control @error('twitter_title') is-invalid @enderror"
                                value="{{ old('twitter_title', $seoPage->twitter_title) }}"
                            >
                            @error('twitter_title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label for="twitter_description" class="form-label">Twitter Description</label>
                            <textarea
                                id="twitter_description"
                                name="twitter_description"
                                rows="3"
                                class="form-control @error('twitter_description') is-invalid @enderror"
                            >{{ old('twitter_description', $seoPage->twitter_description) }}</textarea>
                            @error('twitter_description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="twitter_image" class="form-label">Twitter Image</label>
                            <input
                                type="file"
                                id="twitter_image"
                                name="twitter_image"
                                accept="image/*"
                                class="form-control @error('twitter_image') is-invalid @enderror"
                            >
                            @if(!empty($seoPage->twitter_image))
                                <small class="text-muted d-block mt-1">Current: {{ $seoPage->twitter_image }}</small>
                            @endif
                            @error('twitter_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <hr>
                            <h6 class="mb-0">Advanced SEO</h6>
                        </div>

                        <div class="col-12">
                            <label for="schema_markup" class="form-label">Schema Markup (JSON-LD)</label>
                            <textarea
                                id="schema_markup"
                                name="schema_markup"
                                rows="4"
                                class="form-control @error('schema_markup') is-invalid @enderror"
                            >{{ old('schema_markup', $seoPage->schema_markup) }}</textarea>
                            @error('schema_markup')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="breadcrumb_title" class="form-label">Breadcrumb Title</label>
                            <input
                                type="text"
                                id="breadcrumb_title"
                                name="breadcrumb_title"
                                class="form-control @error('breadcrumb_title') is-invalid @enderror"
                                value="{{ old('breadcrumb_title', $seoPage->breadcrumb_title) }}"
                            >
                            @error('breadcrumb_title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <button class="btn btn-success mt-3">
        Save Content
    </button>
</form>

{{-- Summernote --}}
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    var keywordInput = document.getElementById('meta_keywords_input');
    var keywordHidden = document.getElementById('meta_keywords');
    var keywordTags = document.getElementById('meta_keywords_tags');
    var form = document.querySelector('form[action="{{ route('admin.page-content.update', $page) }}"]');
    var maxKeywords = 10;
    var keywords = [];

    function normalizeKeyword(value) {
        return (value || '').trim().replace(/\s+/g, ' ');
    }

    function setHiddenKeywords() {
        if (keywordHidden) {
            keywordHidden.value = keywords.join(',');
        }
    }

    function renderKeywordTags() {
        if (!keywordTags) return;
        keywordTags.innerHTML = '';

        keywords.forEach(function (keyword) {
            var tag = document.createElement('span');
            tag.className = 'badge text-bg-light border d-inline-flex align-items-center gap-2 px-2 py-1';
            tag.appendChild(document.createTextNode(keyword));

            var removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'btn btn-sm border-0 bg-transparent p-0 lh-1';
            removeBtn.setAttribute('aria-label', 'Remove keyword');
            removeBtn.innerHTML = '&times;';
            removeBtn.addEventListener('click', function () {
                keywords = keywords.filter(function (item) {
                    return item.toLowerCase() !== keyword.toLowerCase();
                });
                setHiddenKeywords();
                renderKeywordTags();
            });

            tag.appendChild(removeBtn);
            keywordTags.appendChild(tag);
        });
    }

    function addKeyword(rawValue) {
        var keyword = normalizeKeyword(rawValue);
        if (!keyword) return;
        if (keywords.length >= maxKeywords) return;

        var duplicate = keywords.some(function (item) {
            return item.toLowerCase() === keyword.toLowerCase();
        });
        if (duplicate) return;

        keywords.push(keyword);
        setHiddenKeywords();
        renderKeywordTags();
    }

    function flushKeywordInput() {
        if (!keywordInput) return;
        if (keywordInput.value.trim() === '') return;
        addKeyword(keywordInput.value.replace(/,+$/, ''));
        keywordInput.value = '';
    }

    if (keywordHidden) {
        keywords = (keywordHidden.value || '')
            .split(',')
            .map(function (item) { return normalizeKeyword(item); })
            .filter(function (item) { return item !== ''; })
            .filter(function (item, idx, arr) {
                return arr.findIndex(function (x) { return x.toLowerCase() === item.toLowerCase(); }) === idx;
            })
            .slice(0, maxKeywords);
        setHiddenKeywords();
        renderKeywordTags();
    }

    if (keywordInput) {
        keywordInput.addEventListener('keydown', function (event) {
            if (event.key === 'Enter' || event.key === ',') {
                event.preventDefault();
                flushKeywordInput();
            }
        });

        keywordInput.addEventListener('blur', function () {
            flushKeywordInput();
        });
    }

    if (form) {
        form.addEventListener('submit', function () {
            flushKeywordInput();
        });
    }

    function initSummernote() {
        if (!window.jQuery || !window.jQuery.fn || !window.jQuery.fn.summernote) return;
        var $content = window.jQuery('#content');
        if (!$content.length) return;
        if ($content.next('.note-editor').length) return;

        $content.summernote({
            height: 350
        });
    }

    if (window.jQuery) {
        window.jQuery(initSummernote);
    } else {
        initSummernote();
    }

    var contentTabBtn = document.getElementById('content-tab');
    if (contentTabBtn) {
        contentTabBtn.addEventListener('shown.bs.tab', function () {
            initSummernote();
        });
    }
});
</script>
@endsection
