@extends('admin.layout')

@section('title', 'Artwork Bulk Upload')

@section('content')
<style>
.bulk-upload-page .hero {
    background: linear-gradient(130deg, #fff8f2 0%, #ffe7d7 40%, #ffffff 100%);
    border: 1px solid #ffd6bc;
    border-radius: 18px;
    padding: 18px;
    box-shadow: 0 10px 25px rgba(230, 115, 44, 0.12);
}

.bulk-upload-page .hero h2 {
    margin: 0;
    font-weight: 700;
}

.bulk-upload-page .hero p {
    margin: 4px 0 0;
    color: #6b7280;
}

.bulk-upload-page .card-shell {
    border-radius: 16px;
    border: 1px solid #ededed;
    box-shadow: 0 10px 24px rgba(15, 23, 42, 0.06);
}

.bulk-upload-page .stat-grid {
    display: grid;
    grid-template-columns: repeat(4, minmax(0, 1fr));
    gap: 12px;
}

.bulk-upload-page .stat-card {
    background: #fff;
    border: 1px solid #ececec;
    border-radius: 12px;
    padding: 14px;
}

.bulk-upload-page .stat-label {
    color: #6b7280;
    font-size: 13px;
}

.bulk-upload-page .stat-value {
    font-size: 24px;
    font-weight: 700;
    color: #1f2937;
    line-height: 1.15;
}

@media (max-width: 992px) {
    .bulk-upload-page .stat-grid {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

@media (max-width: 576px) {
    .bulk-upload-page .stat-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="container py-4 bulk-upload-page">
    <div class="hero d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-3 mb-4">
        <div>
            <h2>Artwork Bulk Upload</h2>
            <p>Upload artworks with XLSX or CSV, auto-create or update by painting code, and review failed rows.</p>
        </div>

        <div class="d-flex flex-wrap gap-2">
            <a href="{{ route('admin.paintings.index') }}" class="btn btn-outline-secondary">Back to Artworks</a>
            <a href="{{ route('admin.paintings.bulk-upload.template') }}" class="btn btn-warning text-white">
                Download Sample
            </a>
        </div>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0 ps-3">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card card-shell mb-4">
        <div class="card-body p-4">
            <form action="{{ route('admin.paintings.bulk-upload') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-3 align-items-end">
                    <div class="col-lg-8">
                        <label for="file" class="form-label fw-semibold">Upload File (XLSX or CSV)</label>
                        <input
                            type="file"
                            id="file"
                            name="file"
                            class="form-control"
                            accept=".xlsx,.csv"
                            required
                        >
                    </div>

                    <div class="col-lg-4 d-grid">
                        <button type="submit" class="btn btn-primary">
                            Upload and Process
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @if (!empty($summary))
        <div class="card card-shell mb-4">
            <div class="card-body p-4">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2 mb-3">
                    <h5 class="mb-0">Import Summary</h5>

                    @if (!empty($rowErrors) && !empty($errorToken))
                        <a href="{{ route('admin.paintings.bulk-upload.errors', $errorToken) }}" class="btn btn-sm btn-outline-danger">
                            Download Error Excel
                        </a>
                    @endif
                </div>

                <div class="stat-grid">
                    <div class="stat-card">
                        <div class="stat-label">Total Rows</div>
                        <div class="stat-value">{{ $summary['total_rows'] ?? 0 }}</div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-label">Created</div>
                        <div class="stat-value text-success">{{ $summary['created'] ?? 0 }}</div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-label">Updated</div>
                        <div class="stat-value text-primary">{{ $summary['updated'] ?? 0 }}</div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-label">Failed</div>
                        <div class="stat-value text-danger">{{ $summary['failed'] ?? 0 }}</div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (!empty($rowErrors))
        <div class="card card-shell">
            <div class="card-body p-0">
                <div class="p-3 border-bottom">
                    <h5 class="mb-0">Failed Rows</h5>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th>Row</th>
                                <th>Title</th>
                                <th>Painting Code</th>
                                <th>Artist</th>
                                <th>Status</th>
                                <th>Reason</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($rowErrors as $errorRow)
                                <tr>
                                    <td>{{ $errorRow['row'] ?? '-' }}</td>
                                    <td>{{ $errorRow['title'] ?? '-' }}</td>
                                    <td>{{ $errorRow['painting_code'] ?? '-' }}</td>
                                    <td>{{ $errorRow['artist_name'] ?? '-' }}</td>
                                    <td>{{ $errorRow['status'] ?? '-' }}</td>
                                    <td class="text-danger">{{ $errorRow['reason'] ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
