@extends('admin.layout')

@section('title', 'Edit Testimonial')

@section('content')
<style>
.tm-form-shell {
    --tm-accent: #e6732c;
    --tm-accent-dark: #cf5f1d;
    --tm-border: #e8edf4;
    --tm-text: #1f2937;
}

.tm-form-card {
    max-width: 760px;
    margin: 0 auto;
    border-radius: 18px;
    border: 1px solid var(--tm-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.tm-form-head {
    padding: 16px 20px;
    background: linear-gradient(120deg, #fff8f2 0%, #fff 70%);
    border-bottom: 1px solid #edf1f7;
}

.tm-form-head h2 {
    margin: 0;
    color: var(--tm-text);
    font-size: 1.4rem;
    font-weight: 700;
}

.tm-form-body {
    padding: 18px 20px;
}

.tm-form-body label {
    font-size: .78rem;
    letter-spacing: .06em;
    text-transform: uppercase;
    font-weight: 700;
    color: #4b5a72;
    margin-bottom: .4rem;
}

.tm-form-body .form-control,
.tm-form-body .form-select {
    min-height: 44px;
    border-radius: 12px;
    border: 1px solid #d9e0eb;
}

.tm-form-body .form-control:focus,
.tm-form-body .form-select:focus {
    border-color: #ebb387;
    box-shadow: 0 0 0 .25rem rgba(230, 115, 44, 0.12);
}

.tm-avatar {
    width: 84px;
    height: 84px;
    border-radius: 50%;
    object-fit: cover;
    border: 1px solid #e5e7eb;
}

.tm-btn-primary {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--tm-accent) 0%, #f09552 100%);
    color: #fff;
    font-weight: 600;
}

.tm-btn-primary:hover {
    background: linear-gradient(135deg, var(--tm-accent-dark) 0%, var(--tm-accent) 100%);
    color: #fff;
}
</style>

<div class="tm-form-shell container-fluid py-4">
    <div class="tm-form-card">
        <div class="tm-form-head d-flex justify-content-between align-items-center">
            <h2>Edit Testimonial</h2>
            <a href="{{ route('admin.testimonials.index') }}" class="btn btn-light">Back</a>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger border-0 m-3 mb-0 shadow-sm">
                <strong>Please fix the following:</strong>
                <ul class="mb-0 mt-2">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('admin.testimonials.update', $testimonial->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="tm-form-body">
                <div class="mb-3">
                    <label>Title</label>
                    <input type="text" name="title" class="form-control" value="{{ old('title', $testimonial->title ?? '') }}">
                </div>

                <div class="mb-3">
                    <label>Client Name</label>
                    <input type="text" name="name" class="form-control" value="{{ old('name', $testimonial->name) }}" required>
                </div>

                <div class="mb-3">
                    <label>Testimonial Message</label>
                    <textarea name="message" rows="4" class="form-control" required>{{ old('message', $testimonial->message) }}</textarea>
                </div>

                @if($testimonial->photo)
                    <div class="mb-3">
                        <label>Current Photo</label><br>
                        <img src="{{ asset('storage/'.$testimonial->photo) }}" class="tm-avatar" alt="{{ $testimonial->name }}">
                    </div>
                @endif

                <div class="mb-3">
                    <label>Change Photo</label>
                    <input type="file" name="photo" class="form-control" accept="image/*">
                </div>

                <div class="mb-3">
                    <label>Sort Order</label>
                    <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', $testimonial->sort_order) }}">
                </div>

                <div class="mb-4">
                    <label>Status</label>
                    <select name="status" class="form-select">
                        <option value="1" {{ $testimonial->status ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ !$testimonial->status ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>

                <div class="d-flex justify-content-between gap-2 flex-wrap">
                    {{-- Delete is intentionally available only on edit page. --}}
                    <button type="button" class="btn btn-outline-danger" onclick="deleteTestimonial()">Delete</button>

                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.testimonials.index') }}" class="btn btn-light">Cancel</a>
                        <button type="submit" class="btn tm-btn-primary px-4">Update</button>
                    </div>
                </div>
            </div>
        </form>

        <form id="deleteTestimonialForm" action="{{ route('admin.testimonials.destroy', $testimonial->id) }}" method="POST" style="display:none;">
            @csrf
            @method('DELETE')
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteTestimonial() {
    if (confirm('Delete this testimonial?')) {
        document.getElementById('deleteTestimonialForm').submit();
    }
}
</script>
@endpush
