@extends('admin.layout')

@section('title', 'Testimonials')

@section('content')
<style>
.testimonial-admin-shell {
    --tm-accent: #e6732c;
    --tm-accent-dark: #cf5f1d;
    --tm-border: #e8edf4;
    --tm-text: #1f2937;
    --tm-muted: #6b7280;
}

.tm-hero {
    border-radius: 18px;
    border: 1px solid #f4d5bf;
    background: linear-gradient(130deg, #fff8f2 0%, #ffffff 58%, #fff1e6 100%);
    box-shadow: 0 16px 38px rgba(15, 23, 42, 0.08);
    padding: 18px 20px;
}

.tm-kicker {
    margin: 0 0 4px;
    text-transform: uppercase;
    letter-spacing: .12em;
    font-size: .74rem;
    font-weight: 700;
    color: var(--tm-accent);
}

.tm-title {
    margin: 0;
    color: var(--tm-text);
    font-weight: 700;
}

.tm-subtitle {
    margin: 6px 0 0;
    color: var(--tm-muted);
    font-size: .95rem;
}

.tm-btn-primary {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--tm-accent) 0%, #f09552 100%);
    color: #fff;
    font-weight: 600;
    box-shadow: 0 14px 24px rgba(230, 115, 44, 0.22);
}

.tm-btn-primary:hover {
    background: linear-gradient(135deg, var(--tm-accent-dark) 0%, var(--tm-accent) 100%);
    color: #fff;
}

.tm-card {
    border-radius: 18px;
    border: 1px solid var(--tm-border);
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.06);
    overflow: hidden;
    background: #fff;
}

.tm-table { margin-bottom: 0; }

.tm-table thead th {
    border-bottom: 1px solid #e9edf5;
    background: #f8fafc;
    color: #3a475a;
    font-size: .78rem;
    letter-spacing: .08em;
    text-transform: uppercase;
    font-weight: 700;
    white-space: nowrap;
}

.tm-table tbody td {
    border-color: #f2f4f8;
    vertical-align: middle;
}

.tm-avatar {
    width: 42px;
    height: 42px;
    border-radius: 50%;
    object-fit: cover;
    border: 1px solid #e5e7eb;
}

.tm-status {
    display: inline-block;
    font-size: .74rem;
    font-weight: 700;
    border-radius: 999px;
    padding: 4px 9px;
}

.tm-status.active { background: #dcfce7; color: #166534; }
.tm-status.inactive { background: #eceff3; color: #475569; }

.tm-empty {
    color: #6b7280;
    text-align: center;
    padding: 42px 12px;
}
</style>

<div class="testimonial-admin-shell container-fluid py-4">
    <div class="tm-hero mb-4 d-flex flex-column flex-lg-row align-items-lg-center justify-content-between gap-3">
        <div>
            <p class="tm-kicker">Homepage Settings</p>
            <h2 class="tm-title">Testimonials</h2>
            <p class="tm-subtitle">Manage client feedback cards shown on frontend.</p>
        </div>

        <a href="{{ route('admin.testimonials.create') }}" class="btn tm-btn-primary px-4">Add Testimonial</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success border-0 shadow-sm">{{ session('success') }}</div>
    @endif

    <div class="tm-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle tm-table">
                <thead>
                    <tr>
                        <th class="ps-3" width="70">S.NO.</th>
                       
                        <th>Client</th>
                        <th>Message</th>
                        <th>Status</th>
                        <th>Order</th>
                        <th class="text-end pe-3" width="120">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($testimonials as $testimonial)
                        <tr>
                            <td class="ps-3">{{ $loop->iteration }}</td>
                           
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    @if($testimonial->photo)
                                        <img src="{{ asset('storage/'.$testimonial->photo) }}" class="tm-avatar" alt="{{ $testimonial->name }}">
                                    @else
                                        <div class="tm-avatar bg-light"></div>
                                    @endif
                                    <strong>{{ $testimonial->name }}</strong>
                                </div>
                            </td>
                            <td style="max-width: 420px;">{{ Str::limit($testimonial->message, 90) }}</td>
                            <td>
                                <span class="tm-status {{ $testimonial->status ? 'active' : 'inactive' }}">
                                    {{ $testimonial->status ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>{{ $testimonial->sort_order }}</td>
                            <td class="text-end pe-3">
                                {{-- List action intentionally only Edit; delete is available on edit page. --}}
                                <a href="{{ route('admin.testimonials.edit', $testimonial->id) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="tm-empty">No testimonials found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
