@extends('artist.layouts.app')

@section('title','Artist Dashboard')

@section('content')

<div class="d-flex justify-content-between mb-3">
    <h4>Your Artworks</h4>

    <a href="{{ route('artist.paintings.create') }}" class="btn btn-dark">
        + Create Artwork
    </a>
</div>

<table class="table table-bordered bg-white align-middle">
    <thead class="table-light">
        <tr>
            <th>Image</th>
            <th>Title</th>
            <th>Price</th>
            <th width="180">Action</th>
        </tr>
    </thead>

    <tbody>
    @forelse($paintings as $painting)
        <tr>
            <td>
                <img src="{{ asset('uploads/paintings/'.$painting->image) }}" width="70">
            </td>

            <td>{{ $painting->title }}</td>

            <td>₹{{ number_format($painting->price) }}</td>

            <td>
                <a href="{{ route('artist.paintings.edit',$painting) }}"
                   class="btn btn-sm btn-warning">
                   Edit
                </a>

                <form action="{{ route('artist.paintings.destroy',$painting) }}"
                      method="POST"
                      class="d-inline">
                    @csrf
                    @method('DELETE')

                    <button class="btn btn-sm btn-danger"
                        onclick="return confirm('Delete artwork?')">
                        Delete
                    </button>
                </form>
            </td>
        </tr>
    @empty
        <tr>
            <td colspan="4" class="text-center">
                No artworks found
            </td>
        </tr>
    @endforelse
    </tbody>
</table>

@endsection
