@extends('artist.layouts.app')

@section('title','Add New Artwork')

@section('content')

<h4 class="fw-bold mb-4">Add New Artwork</h4>

{{-- ERRORS --}}
@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('artist.paintings.store') }}"
      method="POST"
      enctype="multipart/form-data"
      class="card shadow-sm p-4">
@csrf

<input type="hidden" name="artist_id" value="{{ auth('artist')->id() }}">
<input type="hidden" name="status" value="active">

{{-- CODE --}}
<div class="mb-3">
    <label>Artwork Code</label>
    <input type="text"
           name="painting_code"
           value="{{ old('painting_code') }}"
           class="form-control">
</div>

{{-- TITLE --}}
<div class="mb-3">
    <label>Artwork Title *</label>
    <input type="text"
           name="title"
           value="{{ old('title') }}"
           required
           class="form-control">
</div>

{{-- UPDATED BY --}}
<div class="mb-3">
    <label>Updated By</label>
    <input type="text"
           name="updated_by"
           value="{{ old('updated_by') }}"
           placeholder="Artist Name"
           class="form-control">
</div>

{{-- THEMES --}}
<div class="mb-2">
    <label>Themes</label>
    <select id="categoryDropdown" class="form-select">
        <option value="">Select Theme</option>
        @foreach($categories as $category)
            <option value="{{ $category->id }}">{{ $category->name }}</option>
        @endforeach
    </select>
</div>

<div id="selectedCategories" class="d-flex flex-wrap gap-2 mb-2"></div>
<div id="hiddenCategoryInputs"></div>

<small class="text-muted mb-3 d-block">
    Multiple themes select करें, × से remove करें
</small>

{{-- MEDIUM --}}
<div class="mb-3">
    <label>Medium</label>
    <select name="medium_id" class="form-select">
        <option value="">Select Medium</option>
        @foreach($media as $id => $name)
            <option value="{{ $id }}">{{ $name }}</option>
        @endforeach
    </select>
</div>

{{-- FORM --}}
<div class="mb-3">
    <label>Form</label>
    <select name="form_id" class="form-select">
        <option value="">Select Form</option>
        @foreach($forms as $id => $name)
            <option value="{{ $id }}">{{ $name }}</option>
        @endforeach
    </select>
</div>

{{-- DESCRIPTION --}}
<div class="mb-3">
    <label>Description</label>
    <textarea name="description"
              class="summernote">{{ old('description') }}</textarea>
</div>

{{-- PRICE --}}
<div class="mb-3">
    <label>Price</label>
    <input type="number"
           step="0.01"
           name="price"
           value="{{ old('price') }}"
           class="form-control">
</div>

{{-- IMAGE --}}
<div class="mb-2">
    <label>Artwork Image</label>
    <input type="file"
           name="image"
           id="imageInput"
           accept="image/jpeg,image/png"
           class="form-control">
</div>

<small class="text-muted">
✔ JPG/PNG only  
✔ Max 10MB  
✔ Recommended 1200×1200px
</small>

<img id="previewImg"
     style="width:150px;display:none;margin-top:10px;border-radius:8px;">

<div class="mt-4">
    <button class="btn btn-dark px-4">
        Save Artwork
    </button>
</div>

</form>

@endsection

@push('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.css" rel="stylesheet">
@endpush

@push('scripts')

<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.js"></script>

<script>
$('.summernote').summernote({
    height:250
});

// IMAGE PREVIEW
imageInput.onchange = e=>{
    const file=e.target.files[0];
    if(file.size>10*1024*1024){
        alert('Max 10MB');
        e.target.value='';
        return;
    }
    previewImg.src=URL.createObjectURL(file);
    previewImg.style.display='block';
};

// CATEGORY CHIPS
categoryDropdown.onchange=function(){
    const id=this.value;
    const text=this.options[this.selectedIndex].text;
    if(!id || document.getElementById('cat-'+id)) return;

    const chip=document.createElement('span');
    chip.id='cat-'+id;
    chip.className='badge bg-secondary px-3 py-2';
    chip.innerHTML=`${text} ×`;

    const input=document.createElement('input');
    input.type='hidden';
    input.name='category_ids[]';
    input.value=id;

    chip.onclick=()=>{chip.remove();input.remove();};

    selectedCategories.appendChild(chip);
    hiddenCategoryInputs.appendChild(input);
    this.value='';
};
</script>
@endpush
