﻿@extends('layouts.app')

@section('title', $painting->title)

@section('content')
<div class="container py-5">
    <div class="row g-4 align-items-start">
        <div class="col-lg-6">
            <div class="artwork-image-box">
                <img src="{{ asset('uploads/paintings/'.$painting->image) }}"
                     alt="{{ $painting->title }}"
                     class="img-fluid artwork-image">
            </div>
        </div>

        <div class="col-lg-6">
            @if($painting->status === 'sold')
                <span class="badge bg-danger mb-3 px-3 py-2">Sold Out</span>
            @endif

            <h1 class="h3 fw-bold mb-2">{{ $painting->title }}</h1>

            <p class="mb-3 text-muted">
                Artist: <strong>{{ $painting->artist->name ?? 'Unknown Artist' }}</strong>
            </p>

            <div class="price-wrap mb-4">
                @if($painting->status === 'sold')
                    <span class="text-danger fw-semibold">This artwork has been sold.</span>
                @elseif($painting->price_on_request)
                    <span class="fw-semibold">Price on Request</span>
                @elseif(!is_null($painting->price))
                    <span class="fw-bold">₹ {{ number_format((float) $painting->price) }}</span>
                @else
                    <span class="text-muted">Price unavailable</span>
                @endif
            </div>

            <ul class="list-group list-group-flush mb-4 artwork-meta">
                <li class="list-group-item d-flex justify-content-between">
                    <span class="text-muted">Form</span>
                    <strong>{{ $painting->form->name ?? 'N/A' }}</strong>
                </li>
                <li class="list-group-item d-flex justify-content-between">
                    <span class="text-muted">Medium</span>
                    <strong>{{ $painting->medium->name ?? 'N/A' }}</strong>
                </li>
                <li class="list-group-item d-flex justify-content-between">
                    <span class="text-muted">Size</span>
                    <strong>
                        @if($painting->height && $painting->width)
                            {{ rtrim(rtrim(number_format((float) $painting->height, 2, '.', ''), '0'), '.') }} × {{ rtrim(rtrim(number_format((float) $painting->width, 2, '.', ''), '0'), '.') }}
                        @else
                            N/A
                        @endif
                    </strong>
                </li>
                <li class="list-group-item">
                    <span class="text-muted d-block mb-2">Themes</span>
                    @if($painting->categories->count())
                        <div class="d-flex flex-wrap gap-2">
                            @foreach($painting->categories as $category)
                                <span class="badge bg-light text-dark border px-3 py-2">{{ $category->name }}</span>
                            @endforeach
                        </div>
                    @else
                        <span class="text-muted">N/A</span>
                    @endif
                </li>
            </ul>

            <div class="artwork-description">
                <h2 class="h5 mb-3">Description</h2>
                {!! $painting->description !!}
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.artwork-image-box {
    background: #f8f8f8;
    border-radius: 14px;
    padding: 14px;
    border: 1px solid #ececec;
}

.artwork-image {
    width: 100%;
    border-radius: 10px;
    object-fit: contain;
}

.price-wrap {
    font-size: 1.25rem;
}

.artwork-meta .list-group-item {
    padding-left: 0;
    padding-right: 0;
}

.artwork-description {
    line-height: 1.7;
}
</style>
@endpush
