@extends('layouts.app')

@section('title', $about->page_title)

@section('content')

<style>
/* ===== ABOUT PAGE ONLY ===== */
.about-page {
    background:#fff;
    color:#4b2e1e;
    font-family: 'Georgia', serif;
}


/* ===== HERO ===== */
.about-hero {
    background-image: url('{{ asset('uploads/about/'.$about->banner_image) }}');
    background-size: cover;
    background-position: center;
    padding: 120px 0;
    text-align: center;
    position: relative;
}

.about-hero::after {
    content:'';
    position:absolute;
    inset:0;
    background:rgba(255,255,255,.65);
}

.about-hero-content {
    position:relative;
    z-index:2;
}

.about-hero h1 {
    font-size:48px;
    
    letter-spacing:1px;
}

.divider {
    width:120px;
    height:2px;
    background:#b08a5a;
    margin:20px auto;
}

/* ===== SECTIONS ===== */
.about-section {
    padding:70px 0;
}

.about-section h2,
.about-section h3 {
    font-weight:600;
    margin-bottom:15px;
}

.about-section p {
    line-height:1.9;
    font-size:16px;
}

/* ===== STORY (FULL WIDTH BG) ===== */
.story-section {
    background: #8fa9a0;
}

.story-section h3,
.story-section p {
    color:#ffffff;
}

/* ===== IMAGES ===== */
.about-img {
    width:80%;
    border-radius:6px;
}

/* ===== WHY CHOOSE ===== */
.why-box {
    padding:30px;
}

.why-icon {
    font-size:42px;
    margin-bottom:15px;
    color:#8b5e34;
}

/* ===== CTA ===== */
.about-cta {
    background:#8fa9a0;
    padding:70px 20px;
    text-align:center;
}

.about-cta a {
    background:#8b5e34;
    color:#fff;
    padding:14px 40px;
    text-decoration:none;
    font-size:18px;
    border-radius:4px;
    box-shadow:0 6px 18px rgba(0,0,0,.3);
}

.about-cta a:hover {
    background:#6f4522;
}

</style>

<!-- ===== HERO (FULL WIDTH) ===== -->
<section class="about-hero">
    <div class="about-hero-content">
        <!-- <h1>{{ $about->page_title }}</h1> -->
        <!-- <div class="divider"></div>
        <p>{{ $about->breadcrumb_text }}</p> -->
    </div>
</section>

<!-- ===== WELCOME ===== -->
<section class="about-section">
    <div class="site-inner">

        <h2 class="text-center">{{ $about->welcome_title }}</h2>
        <p class="text-center fst-italic mb-4">
            {{ $about->welcome_subtitle }}
        </p>
        <div class="divider"></div>

        <div class="row align-items-center mt-5">
            <div class="col-md-7">
                {!! nl2br(e($about->welcome_description)) !!}
            </div>

            <div class="col-md-5 text-center">
                <img src="{{ asset('uploads/about/'.$about->story_image) }}"
                     class="about-img">
            </div>
        </div>

    </div>
</section>

<!-- ===== STORY (FULL WIDTH BG + ALIGNED CONTENT) ===== -->
<section class="about-section story-section pt-0">
    <div class="site-inner">
<br>
        <h3 class="text-center">{{ $about->story_title }}</h3>
        <div class="divider"></div>

        <div class="mt-4" style="color:#fff;">
            {!! nl2br(e($about->story_description)) !!}
        </div>

    </div>
</section>
<br><br>
<!-- ===== WHY CHOOSE US ===== -->
<section class="about-section pt-0">
    <div class="site-inner">

        <h3 class="text-center mb-4">Why Choose Us?</h3>
        <div class="divider"></div>

        <div class="row text-center mt-5">
            @for($i=1;$i<=3;$i++)
            <div class="col-md-4 why-box">
                <div class="why-icon">
                    @if($i==1) 🖼️ @elseif($i==2) 🌍 @else ❤️ @endif
                </div>
                <h5>{{ $about->{'why_'.$i.'_title'} }}</h5>
                <p>{{ $about->{'why_'.$i.'_desc'} }}</p>
            </div>
            @endfor
        </div>

    </div>
</section>

<!-- ===== COMMITMENT ===== -->
<section class="about-section pt-0">
    <div class="site-inner">

        <div class="row align-items-center">
            <div class="col-md-6">
                <h3>{{ $about->commitment_title }}</h3>
                <p>{{ $about->commitment_description }}</p>
            </div>

            <div class="col-md-6 text-center">
                <img src="{{ asset('uploads/about/'.$about->commitment_image) }}"
                     class="about-img">
            </div>
        </div>

    </div>
</section>

<!-- ===== CTA (FULL WIDTH) ===== -->
<section class="about-cta">
    <h3 class="mb-4">{{ $about->cta_text }}</h3>
    <a href="{{ $about->cta_button_link }}">
        {{ $about->cta_button_text }}
    </a>
</section>
<br>
<!-- ===== SEO CONTENT ===== -->
@if(!empty($pageContents['about']->content))
<section class="seo-content">
    <div class="site-inner">
        {!! $pageContents['about']->content !!}
    </div>
</section>
@endif

@endsection
