@extends('layouts.app')

@section('title', 'Art Advisory')

@section('content')

<section class="py-5 bg-white">
    <div class="site-inner">

        <div class="advisory-grid">

            <!-- LEFT CONTENT -->
            <div class="advisory-content">
                {!! $advisory->content ?? '' !!}
            </div>

            <!-- RIGHT IMAGE -->
            <div class="advisory-image">
                @if($advisory && $advisory->image)
                    <img src="{{ asset('storage/'.$advisory->image) }}" alt="Art Advisory">
                @endif
            </div>

        </div>

    </div>
</section>

@if(!empty($pageContents['art-advisory']->content))
<section class="seo-content">
    <div class="site-inner">
        {!! $pageContents['art-advisory']->content !!}
    </div>
</section>
@endif

@endsection

<style>
    .advisory-grid {
    display: grid;
    grid-template-columns: 1.2fr 1fr;
    gap: 60px;
    align-items: flex-start;
}

.advisory-content {
    font-size: 15px;
    line-height: 1.8;
    color: #444;
}

.advisory-image img {
    width: 100%;
    height: 420px;
    object-fit: cover;
    border-radius: 12px;
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

@media(max-width: 992px) {
    .advisory-grid {
        grid-template-columns: 1fr;
    }

    .advisory-image img {
        height: 320px;
    }
}

</style>