@extends('layouts.app')

@section('title', 'Artists | Creativity Art Gallery')

@section('content')



<section class="meet-artists-section">
    <div class="site-inner">

        <!-- PAGE HEADING -->
        <div class="text-center mb-4"><br>
            <h2 class="section-title">Explore Artists</h2>
            <p class="section-subtitle">
                Discover artworks from established and emerging Indian artists.
            </p>
        </div>

      <div class="row justify-content-center mb-5">
    <div class="col-md-6">

        <div class="search-wrapper">

            <div class="position-relative w-100">
                <input type="text"
                       id="artistSearch"
                       class="search-input"
                       placeholder="Search artist by name..."
                       autocomplete="off">

                <div id="searchSuggestions" class="search-suggestions"></div>
            </div>

            <button type="button" id="searchBtn" class="search-btn">
                🔍
            </button>

        </div>

    </div>
</div>


       @if(isset($featuredArtists) && $featuredArtists->count())
<div class="mb-5">

    <h3 class="mb-4 text-center fw-bold">Featured Artists</h3>

    <div class="featured-artists-wrapper">
        <div class="featured-artists-slider">

            @foreach($featuredArtists->sortBy('name') as $artist)
                <a href="{{ route('artist.detail', $artist->slug) }}"
   class="featured-artist-item artist-item"
   data-name="{{ strtolower($artist->name) }}">


                    <div class="artist-card">

                        <div class="artist-artwork-frame">
                            <img src="{{ asset('uploads/artists/'.$artist->artwork_image) }}"
                                 class="artist-artwork">
                        </div>

                        <div class="artist-avatar">
                            <img src="{{ asset('uploads/artists/'.$artist->profile_image) }}">
                        </div>

                        <p class="artist-name">{{ $artist->name }}</p>

                    </div>
                </a>
            @endforeach

        </div>
    </div>

</div>
@endif


        {{-- ================= OTHER ARTISTS ================= --}}
        <div class="mt-5">

            <h3 class="mb-4 text-center fw-bold">
                Other Artists
            </h3>

            <div class="artists-grid">

                @forelse($artists->sortBy('name') as $artist)
                    <a href="{{ route('artist.detail', $artist->slug) }}"
                       class="artist-link artist-item"
                       data-name="{{ strtolower($artist->name) }}"
                       data-letter="{{ strtolower(substr($artist->name,0,1)) }}">

                        <div class="artist-card">

                            <div class="artist-artwork-frame">
                                <img src="{{ asset('uploads/artists/'.$artist->artwork_image) }}"
                                     alt="{{ $artist->name }}"
                                     class="artist-artwork">
                            </div>

                            <div class="artist-avatar">
                                <img src="{{ asset('uploads/artists/'.$artist->profile_image) }}"
                                     alt="{{ $artist->name }}">
                            </div>

                            <p class="artist-name">{{ $artist->name }}</p>

                        </div>
                    </a>
                @empty
                    <p class="text-center text-muted">No artists found.</p>
                @endforelse

            </div>

            <!-- PAGINATION -->
            <div class="mt-5 d-flex justify-content-center">
                {{ $artists->links() }}
            </div>

        </div>

    </div>
</section>

@if(!empty($pageContents['artists']->content))
<section class="seo-content">
    <div class="site-inner">
        {!! html_entity_decode($pageContents['artists']->content) !!}
    </div>
</section>
@endif

@endsection

<style>
/* SEARCH WRAPPER */
.search-wrapper {
    display: flex;
    align-items: center;
    gap: 12px;
    width: 100%;
}

/* INPUT */
.search-input {
    width: 100%;
    height: 52px;
    border-radius: 40px;
    padding: 0 20px;
    border: 1px solid #ddd;
    outline: none;
    transition: 0.3s ease;
}

.search-input:focus {
    border-color: #8fa9a0;
    box-shadow: 0 0 0 3px rgba(143,169,160,0.15);
}

/* BUTTON */
.search-btn {
    flex-shrink: 0;
    height: 52px;
    width: 52px;
    border-radius: 50%;
    border: none;
    background: #8fa9a0;
    color: #fff;
    font-size: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: 0.3s ease;
}

.search-btn:hover {
    background: #6e867e;
    transform: scale(1.05);
}

/* SUGGESTIONS */
.search-suggestions {
    position: absolute;
    top: 105%;
    left: 0;
    right: 0;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    z-index: 999;
    max-height: 250px;
    overflow-y: auto;
    display: none;
}

.search-suggestions div {
    padding: 12px 16px;
    cursor: pointer;
    font-size: 14px;
    transition: 0.2s ease;
}

.search-suggestions div:hover {
    background: #f5f5f5;
}



    /* REMOVE UNDERLINE FROM ALL ARTIST LINKS (FEATURED + OTHER) */
.featured-artist-item,
.featured-artist-item:hover,
.artist-item,
.artist-item:hover {
    text-decoration: none !important;
    color: inherit !important;
}

/* ================= FEATURED ARTISTS (ARTIST PAGE) ================= */

/* Desktop: normal grid */
.featured-artists-slider {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
}

.featured-artist-item {
    width: 20%;
    padding: 12px;
}

/* Tablet */
@media (max-width: 1200px) {
    .featured-artist-item { width: 25%; }
}
@media (max-width: 992px) {
    .featured-artist-item { width: 33.33%; }
}
/* ================= FEATURED ARTISTS – HOME LIKE MOBILE ================= */
@media (max-width: 576px) {

    .featured-artists-wrapper {
        overflow: hidden;   /* 🔒 clip */
        width: 100%;
    }

    .featured-artists-slider {
        display: flex;
        flex-wrap: nowrap;
        justify-content: flex-start;
        will-change: transform;
    }

    .featured-artist-item {
        flex: 0 0 50%;
        max-width: 50%;
        padding: 12px;
    }

    /* SAME CARD SIZE AS HOME */
    .featured-artists-slider .artist-artwork-frame {
        padding: 7px;
    }

    .featured-artists-slider .artist-artwork {
        height: 105px;
        object-fit: cover;
    }

    .featured-artists-slider .artist-avatar img {
        width: 56px;
        height: 56px;
    }

    .featured-artists-slider .artist-name {
        margin-top: 54px;
    }
}




.alphabet-filter {
    font-size: 14px;
}

.alphabet {
    display: inline-block;
    margin: 0 6px;
    cursor: pointer;
    font-weight: 500;
    color: #777;
}

.alphabet.active {
    color: #000;
    font-weight: 700;
    text-decoration: underline;
}
</style>





{{-- ================= STYLES ================= --}}
<style>

/* GRID */
.artists-grid {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
}

/* EXACT 5 PER ROW */
.artist-link {
    width: 20%;
    padding: 12px;
    text-decoration: none;
    color: inherit;
}

/* CARD */
.artist-card {
    background: #ffffff;
    border-radius: 14px;
    text-align: center;
    padding-bottom: 1px;
    box-shadow: 0 10px 26px rgba(0,0,0,0.12);
    position: relative;
    transition: 0.3s ease;
}

.artist-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 18px 40px rgba(0,0,0,0.18);
}

/* ARTWORK */
.artist-artwork-frame {
    background: #d9d9d9;
    padding: 10px;
    border-radius: 14px 14px 0 0;
}

.artist-artwork {
    width: 100%;
    height: 220px;
    object-fit: cover;
    border-radius: 10px;
}

/* AVATAR */
.artist-avatar {
    position: absolute;
    left: 50%;
    bottom: 56px;
    transform: translateX(-50%);
    background: #fff;
    padding: 6px;
    border-radius: 50%;
}

.artist-avatar img {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    object-fit: cover;
}

/* NAME */
.artist-name {
    margin-top: 60px;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.4px;
    color: #000;
}

/* RESPONSIVE */
@media (max-width: 1200px) {
    .artist-link { width: 25%; }
}
@media (max-width: 992px) {
    .artist-link { width: 33.33%; }
}
@media (max-width: 576px) {
    .artist-link { width: 50%; }
}


/* ================= OTHER ARTISTS – MOBILE GRID (NO SLIDER) ================= */
@media (max-width: 576px) {

    .artists-grid {
        display: flex;
        flex-wrap: wrap;          /* ✅ allow next row */
        justify-content: center;
    }

    .artist-link {
        width: 50%;               /* ✅ 2 per row */
        padding: 12px;
    }

    /* SAME SIZE AS FEATURED (HOME FEEL) */
    .artists-grid .artist-artwork-frame {
        padding: 7px;
    }

    .artists-grid .artist-artwork {
        height: 105px;
        object-fit: cover;
    }

    .artists-grid .artist-avatar img {
        width: 56px;
        height: 56px;
    }

    .artists-grid .artist-name {
        margin-top: 54px;
    }
}



</style>

@push('scripts')


<script>
document.addEventListener("DOMContentLoaded", function () {

    if (window.innerWidth > 576) return;

    const row = document.querySelector('.featured-artists-slider');
    if (!row) return;

    let items = Array.from(row.children);
    if (items.length < 3) return;

    function initSlider() {

        const itemWidth = items[0].getBoundingClientRect().width;
        if (itemWidth === 0) {
            requestAnimationFrame(initSlider);
            return;
        }

        let index = 1;

        const firstClone = items[0].cloneNode(true);
        const lastClone  = items[items.length - 1].cloneNode(true);

        row.appendChild(firstClone);
        row.insertBefore(lastClone, items[0]);

        items = Array.from(row.children);

        row.style.transition = 'none';
        row.style.transform = `translateX(-${itemWidth}px)`;

        setInterval(() => {
            index++;
            row.style.transition = 'transform 0.6s ease';
            row.style.transform = `translateX(-${index * itemWidth}px)`;

            if (index === items.length - 1) {
                setTimeout(() => {
                    row.style.transition = 'none';
                    index = 1;
                    row.style.transform = `translateX(-${itemWidth}px)`;
                }, 650);
            }
        }, 3000);
    }

    requestAnimationFrame(initSlider);
});
</script>



<script>
document.addEventListener('DOMContentLoaded', function () {

    const searchInput = document.getElementById('artistSearch');
    const suggestionsBox = document.getElementById('searchSuggestions');
    const artistItems = document.querySelectorAll('.artist-item');

    function getArtistNames() {
        const names = [];

        artistItems.forEach(item => {
            const name = item.dataset.name;
            if (name && !names.includes(name)) {
                names.push(name);
            }
        });

        return names;
    }

    const allNames = getArtistNames();

    searchInput.addEventListener('input', function () {

        const value = this.value.toLowerCase().trim();
        suggestionsBox.innerHTML = '';

      if (value === '') {
    suggestionsBox.style.display = 'none';
    artistItems.forEach(item => item.style.display = '');
    return;
}


        const filtered = allNames.filter(name =>
            name.includes(value)
        );

        if (filtered.length === 0) {
            suggestionsBox.style.display = 'none';
            return;
        }

        filtered.forEach(name => {
            const div = document.createElement('div');
            div.textContent = name;
            div.addEventListener('click', function () {

                searchInput.value = name;
                suggestionsBox.style.display = 'none';

                filterGrid(name);
            });

            suggestionsBox.appendChild(div);
        });

        suggestionsBox.style.display = 'block';
    });

    function filterGrid(name) {
        artistItems.forEach(item => {
            item.style.display =
                item.dataset.name === name ? '' : 'none';
        });
    }

   document.addEventListener('click', function(e) {
    if (
        !searchInput.contains(e.target) &&
        !suggestionsBox.contains(e.target)
    ) {
        suggestionsBox.style.display = 'none';
    }
});


});
</script>

@endpush

