@extends('layouts.app')

@section('title', $artist->name . ' | Artist')

@section('content')

<style>
/* ================= FULL WIDTH ARTIST BANNER ================= */
.artist-banner-wrapper{
    background:#8F9A90;
    width:100vw;
    margin-left:calc(-50vw + 50%);
    margin-right:calc(-50vw + 50%);
}
.painting-banner{
    padding:30px 0;
    display:flex;
    gap:30px;
    align-items:center;
    color:#fff;
}
.artist-bio{
    flex:1;
}
.painting-banner h2,
.painting-banner p{color:#fff}
.painting-banner img{
    width:220px;
    height:220px;
    border-radius:50%;
    object-fit:cover;
    background:#fff;
    padding:6px;
}
#readMoreBtn{
    color:#000;
    font-weight:600;
    cursor:pointer;
}

/* ================= ENQUIRY BAR ================= */
.enquiry-bar{
    background:#f3f3f3;
    border:1px solid #ddd;
    border-radius:10px;
    padding:16px 22px;
    display:flex;
    justify-content:center;
    align-items:center;
    gap:56px;
    box-shadow:0 3px 10px rgba(0,0,0,0.08);
    max-width:60%;
    margin:0 auto;
}
.enquiry-text{
    font-size:17px;
    font-weight:500;
    color:#333;
    flex:0 1 auto;
    margin:0;
    padding-left:10px;
}
.enquiry-btn{
    background:linear-gradient(#ffd65a,#f4b400);
    color:#000;
    font-weight:600;
    padding:10px 26px;
    border-radius:8px;
    text-decoration:none;
    border:1px solid #e0a800;
}
@media (max-width: 768px){
    .enquiry-bar{
        max-width:100%;
        margin:0;
        padding:10px 12px;
        gap:10px;
        border-radius:8px;
    }
    .enquiry-text{
        padding-left:0;
        font-size:13px;
        line-height:1.35;
        margin:0;
    }
    .enquiry-btn{
        padding:7px 12px;
        font-size:13px;
        border-radius:6px;
        white-space:nowrap;
    }
}

/* ================= FILTER ================= */
#filterForm .form-control,
#filterForm .form-select{
    height:44px;
}
#filterForm .fw-semibold{
    display:block;
    margin-bottom:10px;
}
.filter-label{
    line-height:2.2;
}
.dual-range{
    position:relative;
    height:28px;
}
.dual-range::before{
    content:"";
    position:absolute;
    top:12px;
    left:0;
    right:0;
    height:4px;
    border-radius:999px;
    background:#e3e3e3;
}
.dual-range-track{
    position:absolute;
    top:12px;
    height:4px;
    border-radius:999px;
    background:#dc3545;
    left:0;
    right:0;
}
.range-input{
    position:absolute;
    left:0;
    top:0;
    width:100%;
    height:28px;
    margin:0;
    pointer-events:none;
    background:transparent;
    -webkit-appearance:none;
    appearance:none;
}
.range-input::-webkit-slider-runnable-track{
    height:4px;
    background:transparent;
}
.range-input::-moz-range-track{
    height:4px;
    background:transparent;
}
.range-input::-webkit-slider-thumb{
    -webkit-appearance:none;
    appearance:none;
    width:16px;
    height:16px;
    margin-top:-6px;
    border-radius:50%;
    border:2px solid #fff;
    background:#dc3545;
    box-shadow:0 1px 4px rgba(0,0,0,.25);
    pointer-events:auto;
    cursor:pointer;
}
.range-input::-moz-range-thumb{
    width:16px;
    height:16px;
    border-radius:50%;
    border:2px solid #fff;
    background:#dc3545;
    box-shadow:0 1px 4px rgba(0,0,0,.25);
    pointer-events:auto;
    cursor:pointer;
}

/* ================= GRID ================= */
.painting-card{
    background:#fff;
    padding:12px;
    border-radius:12px;
    box-shadow:0 4px 18px rgba(0,0,0,.09);
}
.painting-image{
    aspect-ratio:1/1;
    background:#f6f6f6;
    border-radius:10px;
    display:flex;
    align-items:center;
    justify-content:center;
}
.painting-image img{
    width:100%;
    height:100%;
    object-fit:contain;
    
}
.painting-body{
    padding-top:10px;
}
.artist-avatar{
    width:220px;
    height:220px;
    border-radius:50%;
    background:#fff;
    padding:1px;
    flex-shrink:0;           /* 🔑 PREVENT FLEX DISTORTION */
    display:flex;
    align-items:center;
    justify-content:center;
}

.artist-avatar img{
    width:100%;
    height:100%;
    border-radius:50%;
    object-fit:cover;
}

@media (max-width: 768px){
    .painting-banner{
        flex-direction:column;
        align-items:center;
        gap:16px;
        text-align:center;
    }
    .artist-avatar{
        width:170px;
        height:170px;
    }
    .artist-bio{
        width:100%;
        text-align:center;
    }
}

</style>

{{-- ================= ARTIST BANNER ================= --}}
<div class="artist-banner-wrapper">
    <div class="site-inner">
        <div class="painting-banner">
          <div class="artist-avatar">
    <img src="{{ asset('uploads/artists/'.$artist->profile_image) }}">
</div>

            <div class="artist-bio">
                <h2>{{ $artist->name }}</h2>

                <p id="shortBio">
                    {{ \Illuminate\Support\Str::limit($artist->bio,220) }}
                </p>

                <div id="fullBio" style="max-height:0;overflow:hidden;transition:max-height .4s ease;">
                    <p>{{ $artist->bio }}</p>
                </div>

                <span id="readMoreBtn">READ MORE →</span>
            </div>
        </div>
    </div>
</div>

{{-- ================= MAIN CONTENT ================= --}}
<div class="site-inner my-5">

    {{-- ENQUIRY BAR --}}
    <div class="enquiry-bar mb-5">
        <div class="enquiry-text">
            Interested in artworks by this artist beyond what’s shown here?
        </div>
       <button class="enquiry-btn"
        data-bs-toggle="modal"
        data-bs-target="#artistEnquiryModal">
    Enquiry
</button>

    </div>

    {{-- FILTERS --}}
    <form id="filterForm" class="row g-3 align-items-end mb-4">
        <input type="hidden" name="artist_id" value="{{ $artist->id }}">

        {{-- PRICE --}}
        <div class="col-md-4 d-flex flex-column">
            <label class="fw-semibold mb-2 filter-label">
                Price:
                <span id="priceLabel">&#8377;0 - &#8377;50,00,000</span>
            </label>
            <div class="dual-range">
                <div class="dual-range-track" id="priceTrack"></div>
                <input type="range"
                       id="priceMinRange"
                       class="range-input range-input-min"
                       min="0"
                       max="5000000"
                       step="25000"
                       value="0">
                <input type="range"
                       id="priceMaxRange"
                       class="range-input range-input-max"
                       min="0"
                       max="5000000"
                       step="25000"
                       value="5000000">
            </div>
            <input type="hidden" name="price_min" id="priceMin" value="0">
            <input type="hidden" name="price_max" id="priceMax" value="5000000">
        </div>

        {{-- FORM --}}
        <div class="col-md-4">
            <label class="fw-semibold">Form</label>
            <select name="form" class="form-select">
                <option value="">All Forms</option>
                @foreach($forms as $form)
                    <option value="{{ $form->id }}">{{ $form->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- THEMES --}}
        <div class="col-md-4">
            <label class="fw-semibold">Themes</label>
            <select id="themeDropdown" class="form-select">
                <option value="">Select Theme</option>
                @foreach($categories as $cat)
                    <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- RESET --}}
        <div class="col-12 text-end">
            <button type="button" id="resetFilters" class="btn btn-outline-dark px-4">
                Reset All Filters
            </button>
        </div>
    </form>

    <div id="selectedThemes" class="d-flex gap-2 mb-4 flex-wrap"></div>

    {{-- PAINTINGS --}}
    <div id="paintingResults">
        @include('front.paintings.partials.painting_grid',['paintings'=>$paintings])
    </div>

</div>

{{-- ================= ARTIST ENQUIRY MODAL ================= --}}
<div class="modal fade" id="artistEnquiryModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form id="artistEnquiryForm" class="modal-content">
            @csrf

            <div class="modal-header">
                <h5 class="modal-title">Enquiry About {{ $artist->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                {{-- SUCCESS --}}
                <div id="artistEnquirySuccess"
                     class="alert alert-success d-none text-center mb-3"></div>

                <input type="text"
                       name="name"
                       class="form-control mb-3"
                       placeholder="Your Name"
                       required>

                <input type="email"
                       name="email"
                       class="form-control mb-3"
                       placeholder="Your Email"
                       required>

                <input type="text"
                       name="phone"
                       class="form-control mb-3"
                       placeholder="Phone Number (Optional)">

                <textarea name="message"
                          class="form-control mb-3"
                          rows="4"
                          required
                          placeholder="Message about {{ $artist->name }}"></textarea>

                {{-- HIDDEN --}}
                <input type="hidden" name="artist_name" value="{{ $artist->name }}">

            </div>

            <div class="modal-footer">
                <button type="submit" class="btn btn-dark w-100">
                    Send Enquiry
                </button>
            </div>
        </form>
    </div>
</div>

@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {

    const form = document.getElementById('artistEnquiryForm');
    const successBox = document.getElementById('artistEnquirySuccess');
    const modalEl = document.getElementById('artistEnquiryModal');

    if (!form) return;

    form.addEventListener('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(form);

        fetch("{{ route('artist.enquiry.store') }}", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': form.querySelector('input[name=_token]').value,
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                successBox.innerText = data.message;
                successBox.classList.remove('d-none');
                form.reset();

                setTimeout(() => {
                    bootstrap.Modal.getInstance(modalEl).hide();
                    successBox.classList.add('d-none');
                }, 2000);
            }
        })
        .catch(() => alert('Something went wrong. Please try again.'));
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', function(){

/* READ MORE */
const btn=document.getElementById('readMoreBtn'),
full=document.getElementById('fullBio'),
short=document.getElementById('shortBio');

btn.onclick=()=>{
    const open=full.style.maxHeight && full.style.maxHeight!=='0px';
    full.style.maxHeight=open?'0':'600px';
    short.style.display=open?'block':'none';
    btn.textContent=open?'READ MORE →':'SHOW LESS ↑';
};

/* FILTERS */
const baseUrl="{{ route('artist.detail',$artist->slug) }}";
const form=document.getElementById('filterForm');
const results=document.getElementById('paintingResults');
const priceMinRange=document.getElementById('priceMinRange');
const priceMaxRange=document.getElementById('priceMaxRange');
const priceTrack=document.getElementById('priceTrack');
const priceMax=document.getElementById('priceMax');
const priceMin=document.getElementById('priceMin');
const priceLabel=document.getElementById('priceLabel');
const themeDropdown=document.getElementById('themeDropdown');
const selectedBox=document.getElementById('selectedThemes');
const resetBtn=document.getElementById('resetFilters');

let themes=[];

/* PRICE */
const PRICE_STEP=25000;
const PRICE_MAX_LIMIT=5000000;

function updatePriceUI(changedBy='max'){
    let minValue=Number(priceMinRange.value);
    let maxValue=Number(priceMaxRange.value);

    if((maxValue-minValue)<PRICE_STEP){
        if(changedBy==='min'){
            minValue=maxValue-PRICE_STEP;
            priceMinRange.value=minValue;
        }else{
            maxValue=minValue+PRICE_STEP;
            priceMaxRange.value=maxValue;
        }
    }

    priceMin.value=minValue;
    priceMax.value=maxValue;
    priceLabel.innerText=`\u20B9${minValue.toLocaleString()} - \u20B9${maxValue.toLocaleString()}`;

    const minPercent=(minValue/PRICE_MAX_LIMIT)*100;
    const maxPercent=(maxValue/PRICE_MAX_LIMIT)*100;
    priceTrack.style.left=`${minPercent}%`;
    priceTrack.style.right=`${100-maxPercent}%`;
}

priceMinRange.oninput=()=>{
    updatePriceUI('min');
    fetchPaintings();
};

priceMaxRange.oninput=()=>{
    updatePriceUI('max');
    fetchPaintings();
};
updatePriceUI();

/* THEMES */
themeDropdown.onchange=function(){
    const id=this.value,text=this.options[this.selectedIndex].text;
    if(!id||themes.includes(id))return;
    themes.push(id);

    const chip=document.createElement('span');
    chip.className='badge bg-dark px-3 py-2';
    chip.innerHTML=`${text} ✕`;
    chip.onclick=()=>{
        themes=themes.filter(t=>t!==id);
        chip.remove();
        fetchPaintings();
    };
    selectedBox.appendChild(chip);
    fetchPaintings();
    this.value='';
};

/* FETCH */
function fetchPaintings(url=baseUrl){
    const params=new URLSearchParams(new FormData(form));
    themes.forEach(t=>params.append('categories[]',t));

    const page=new URL(url,window.location.origin).searchParams.get('page');
    if(page) params.set('page',page);

    fetch(baseUrl+'?'+params,{
        headers:{'X-Requested-With':'XMLHttpRequest'}
    })
    .then(r=>r.text())
    .then(h=>results.innerHTML=h);
}

/* RESET */
resetBtn.onclick=()=>{
    form.reset();
    themes=[];
    selectedBox.innerHTML='';
    priceMinRange.value=0;
    priceMaxRange.value=5000000;
    priceMin.value=0;
    priceMax.value=5000000;
    updatePriceUI();
    fetchPaintings();
};

/* CHANGE */
form.onchange=()=>fetchPaintings();

/* PAGINATION */
document.addEventListener('click',function(e){
    const link=e.target.closest('.pagination a');
    if(!link)return;
    e.preventDefault();
    fetchPaintings(link.href);
});

});
</script>
@endpush

