@extends('layouts.app')

@section('title', 'Artworks')

@section('content')
<div class="container py-5">

    <h2 class="text-center fw-bold mb-4">Explore Artworks</h2>

    <div class="row g-4">

        @foreach($artworks as $artwork)
        <div class="col-6 col-md-4 col-lg-3">

            <a href="{{ route('artworks.show', $artwork->slug) }}"
               class="text-decoration-none">

                <div class="card shadow-sm h-100 text-center artwork-card">

                    <div class="artwork-image">
                        <img src="{{ asset('uploads/artworks/'.$artwork->image) }}"
                             alt="{{ $artwork->name }}">
                    </div>

                    <div class="card-body">
                        <h5 class="fw-semibold text-dark">
                            {{ $artwork->name }}
                        </h5>
                    </div>

                </div>

            </a>

        </div>
        @endforeach

    </div>

</div>


@if(!empty($pageContents['artworks']->content))
<section class="seo-content">
    <div class="container">
        {!! $pageContents['artworks']->content !!}
    </div>
</section>
@endif

@endsection


<style>
.artwork-card {
    border-radius: 10px;
    transition: .3s;
}

.artwork-card:hover {
    transform: translateY(-6px);
}

.artwork-image {
    height: 220px;
    overflow: hidden;
}

.artwork-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
</style>
