@extends('layouts.app')

@section('title', $artwork->name)

@section('content')
<div class="container py-5">

    <h2 class="text-center fw-bold mb-4">
        {{ $artwork->name }}
    </h2>

    <!-- 🔍 FILTER BAR (MATCHES PAINTING PAGE UI) -->
    <form method="GET"
          class="row g-3 align-items-end justify-content-center mb-4">

        <!-- Search -->
        <div class="col-md-4 col-sm-6">
            <label class="form-label fw-semibold">Artwork Name</label>
            <input type="text"
                   name="q"
                   value="{{ request('q') }}"
                   class="form-control"
                   placeholder="Search artwork...">
        </div>

        <!-- Form -->
        <div class="col-md-3 col-sm-6">
            <label class="form-label fw-semibold">Form</label>
            <select name="form" class="form-select">
                <option value="">All Forms</option>
                @foreach($forms as $form)
                    <option value="{{ $form->id }}"
                        {{ request('form') == $form->id ? 'selected' : '' }}>
                        {{ $form->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Medium -->
        <div class="col-md-3 col-sm-6">
            <label class="form-label fw-semibold">Medium</label>
            <select name="medium" class="form-select">
                <option value="">All Mediums</option>
                @foreach($mediums as $medium)
                    <option value="{{ $medium->id }}"
                        {{ request('medium') == $medium->id ? 'selected' : '' }}>
                        {{ $medium->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Buttons -->
        <div class="col-md-2 col-sm-6 d-flex gap-2">
            <button class="btn btn-danger w-100">
                Search
            </button>
            <a href="{{ route('artworks.show', $artwork->slug) }}"
               class="btn btn-outline-secondary w-100">
                Reset
            </a>
        </div>

    </form>

    <!-- 🖼️ PAINTINGS GRID (4 PER ROW) -->
    <div class="row g-4">

        @forelse($paintings as $painting)
        <div class="col-6 col-md-3">

            <div class="painting-card position-relative">

                <!-- ❤️ Favourite -->
                <div class="position-absolute top-0 end-0 p-2 z-1">
                    @auth
                        <a href="{{ route('favourite.toggle', $painting->id) }}"
                           class="btn btn-sm btn-outline-danger rounded-circle bg-white">
                            ❤️
                        </a>
                    @endauth
                </div>

                <!-- Image -->
                <div class="painting-image">
                    <img src="{{ asset('uploads/paintings/'.$painting->image) }}"
                         alt="{{ $painting->title }}">
                </div>

                <!-- Body -->
                <div class="painting-body text-center">
                    <h6 class="fw-semibold">
                        {{ Str::limit($painting->title, 22) }}
                    </h6>

                    <div class="price fw-bold mb-2">
                        @if($painting->price_on_request)
                            <span class="text-danger">Price on Request</span>
                        @elseif(!is_null($painting->price))
                            <span class="text-success">&#8377; {{ number_format((int) $painting->price) }}</span>
                        @else
                            <span class="text-muted"></span>
                        @endif
                    </div>

                    <a href="{{ route('painting.show', $painting->id) }}"
                       class="btn btn-danger btn-sm w-100">
                        View Details →
                    </a>
                </div>

            </div>

        </div>
        @empty
            <div class="col-12 text-center text-muted">
                No artworks found.
            </div>
        @endforelse

    </div>

    <!-- Pagination -->
    <div class="mt-4">
        {{ $paintings->withQueryString()->links() }}
    </div>

</div>
@endsection


{{-- ================= STYLES (SAME AS PAINTINGS PAGE) ================= --}}
<style>
.painting-card {
    border-radius: 10px;
    overflow: hidden;
    transition: .3s;
    background: #fff;
    height: 100%;
}

.painting-card:hover {
    transform: translateY(-5px);
}

.painting-image {
    height: 240px;
    width: 100%;
    overflow: hidden;
    background: #f5f5f5;
}

.painting-image img {
    width: 100%;
    height: 100%;
    object-fit: contain;
}

.painting-body {
    padding: 12px;
    text-align: center;
}

.price {
    font-size: 16px;
    color: #148c2e;
}

@media(max-width: 576px) {
    .painting-image { height: 180px; }
}
</style>
