@extends('layouts.app')

@section('content')

<style>
    /* ================= BLOG IMAGE – 16:9 FIX ================= */

.blog-image {
    position: relative;
    width: 100%;
    aspect-ratio: 16 / 9;   /* ✅ force 16:9 */
    overflow: hidden;
    border-radius: 6px;
    background: #eee;
}

.blog-image img {
    position: absolute;
    inset: 0;

    width: 100%;
    height: 100%;
    object-fit: cover;      /* ✅ no stretch */
}

/* ================= BLOG HERO ================= */
.blog-hero {
    padding:40px 0;
}

/* ================= BLOG CARD ================= */
.blog-card-ui {
    display: grid;
    grid-template-columns: 1.1fr 1fr;
    gap: 60px;
    align-items: center;
    margin-bottom: 80px;
}



.blog-content h2 {
    font-size: 34px;
    font-weight: 600;
    margin-bottom: 18px;
    line-height: 1.3;
}

.blog-content p {
    font-size: 16px;
    line-height: 1.9;
    color: #555;
    margin-bottom: 20px;
}
/* ================= READ MORE BUTTON ================= */
.blog-read-btn {
    position: relative;
    display: inline-flex;
    align-items: center;
    height: 48px;
    width: 48px;                 /* initial round button */
    background: #7c9486;
    border-radius: 30px;
    text-decoration: none;
    overflow: hidden;
    transition: width 0.45s ease;
    margin-top: 10px;
}

/* TEXT */
.blog-read-text {
    position: absolute;
    left: 18px;                  /* text start */
    white-space: nowrap;
    color: #fff;
    font-weight: 600;
    font-size: 14px;
    opacity: 0;
    transform: translateX(-6px);
    transition: opacity 0.25s ease, transform 0.35s ease;
}

/* ARROW – ALWAYS VISIBLE */
.blog-read-arrow {
    position: absolute;
    right: 16px;                 /* ✅ button ke andar rahe */
    color: #fff;
    font-size: 16px;
    transition: transform 0.35s ease;
}

/* EXPAND */
.blog-read-btn:hover {
    width: 140px;                /* ❌ 180 hata diya → extra space gone */
}

.blog-read-btn:hover .blog-read-text {
    opacity: 1;
    transform: translateX(0);
}

.blog-read-btn:hover .blog-read-arrow {
    transform: translateX(2px);
}

/* MOBILE – ALWAYS EXPANDED */
@media (max-width: 768px) {
    .blog-read-btn {
        width: 140px;
    }

    .blog-read-text {
        opacity: 1;
        transform: translateX(0);
    }
}


/* ================= CATEGORY BAR ================= */
.category-bar {
    margin-bottom: 60px;
    text-align: center;
}

.category-bar a {
    border-radius: 30px;
    padding: 8px 18px;
    font-size: 14px;
    margin: 5px;
}

/* ================= RESPONSIVE ================= */
@media(max-width: 991px){
    .blog-card-ui {
        grid-template-columns: 1fr;
    }

    .blog-card-ui img {
        height: 260px;
    }
}
</style>

<!-- ================= BLOG LISTING ================= -->
<section class="blog-hero">
    <div class="site-inner">

        <!-- TITLE -->
        <h2 class="text-center mb-2">Blogs</h2>
        <p class="text-center text-muted mb-5">
            Explore insights, guidance, and perspectives from the world of art.
        </p>

        <!-- CATEGORY FILTER -->
        <div class="category-bar">
            <a href="{{ \App\Models\SeoPage::url('blog', '/blogs') }}"
               class="btn {{ !isset($category) ? 'btn-dark' : 'btn-outline-dark' }}">
                View All
            </a>

            @foreach($categories as $cat)
                <a href="{{ route('blogs.category', $cat->slug) }}"
                   class="btn {{ (isset($category) && $category->id == $cat->id) ? 'btn-dark' : 'btn-outline-dark' }}">
                    {{ $cat->name }}
                </a>
            @endforeach
        </div>

        <!-- BLOG LIST -->
        @forelse($blogs as $blog)
            <div class="blog-card-ui">

                <!-- IMAGE -->
                <div>
                    @if($blog->image)
                       <div class="blog-image">
    <img src="{{ asset('uploads/blogs/'.$blog->image) }}"
         alt="{{ $blog->title }}">
</div>

                    @else
                        <div style="height:360px;background:#eaeaea;border-radius:6px;"></div>
                    @endif
                </div>

                <!-- CONTENT -->
                <div class="blog-content">
                    <h2>{{ $blog->title }}</h2>

                    <!-- <p class="text-muted small mb-3">
                        {{ $blog->created_at->format('d M, Y') }}
                    </p> -->

                    <p>
                        {{ \Illuminate\Support\Str::limit($blog->short_description, 280) }}
                    </p>

                    <a href="{{ route('blogs.show', $blog->slug) }}"
                       class="blog-read-btn">
                        <span class="blog-read-text">Read more</span>
                        <span class="blog-read-arrow">
                            <i class="fa fa-arrow-right"></i>
                        </span>
                    </a>
                </div>

            </div>
        @empty
            <p class="text-center">No blogs found.</p>
        @endforelse

        <!-- PAGINATION -->
        <div class="d-flex justify-content-center mt-4">
            {{ $blogs->links() }}
        </div>

    </div>
</section>

<!-- ================= SEO CONTENT ================= -->
@if(!empty($pageContents['blogs']->content))
<section class="seo-content">
    <div class="site-inner">
        {!! $pageContents['blogs']->content !!}
    </div>
</section>
@endif

@endsection
