@include('layouts.header')

@php
    use Illuminate\Support\Str;
@endphp

<style>
/* (same CSS you had, shortened here for clarity) */
.painting-banner {
    background: #f5e9d8;
    padding: 30px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    gap: 30px;
}
.painting-banner img {
    width: 250px;
    height: 250px;
    object-fit: contain;
    border-radius: 50%;
    padding: 6px;
    background: #fff;
}
.painting-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 25px;
}
.painting-card { background:#fff; padding:15px; border-radius:12px; box-shadow:0 4px 18px rgba(0,0,0,0.09); }
.painting-card img { width:100%; height:280px; object-fit:cover; border-radius:10px; }
.card-image-wrapper { position:relative; }
.sold-badge {
    position:absolute; top:10px; right:10px;
    background:#000; color:#fff; padding:4px 10px;
    border-radius:6px; font-size:13px;
}
#readMoreBtn {
    transition: 0.3s;
}

#readMoreBtn:hover {
    color: #c46f36;
}
</style>

<div class="container-fluid" style="padding-bottom:50px; padding-left:0; padding-right:0;">

    <div class="painting-banner">
        {{-- Category banner image from categories.image --}}
        <img src="{{ asset('uploads/categories/' . $category->image) }}"
             alt="{{ $category->name }}" style="margin-left:44px;">

        <div style="flex:1; margin:40px;">
            <h2>{{ $category->name }}</h2>

            <p>{{ Str::limit($category->description, 180) }}</p>

           <div id="moreContent" style="
    max-height:0;
    overflow:hidden;
    transition:max-height 0.5s ease;
    font-size:15px;
    line-height:1.6;
">
    <p>{{ $category->description }}</p>
</div>


<a id="readMoreBtn" style="
    font-weight:bold;
    cursor:pointer;
    display:inline-block;
    margin-top:12px;
">READ MORE →</a>
        </div>
    </div>
</div>

<div class="painting-grid" style="margin-left:70px; margin-right:70px; padding-bottom:40px;">

    @if($paintings->isEmpty())
        <p style="text-align:center; font-size:18px; font-weight:600; padding:40px;">
            No paintings found in this category.
        </p>
    @endif

    @foreach($paintings as $painting)
        <div class="painting-card">
            <div class="card-image-wrapper">
                @if(strtolower($painting->status) === 'sold')
                    <span class="sold-badge">SOLD</span>
                @endif

                <img src="{{ asset('uploads/paintings/' . $painting->image) }}"
                     alt="{{ $painting->title }}">
            </div>

            <h4>{{ $painting->title }}</h4>
            <p>Artist: {{ $painting->artist->name ?? 'Unknown' }}</p>
            @if($painting->price)
                <p class="price">&#8377;{{ number_format((int) $painting->price) }}</p>
            @endif
        </div>
    @endforeach
</div>

<script>
document.getElementById("readMoreBtn").addEventListener("click", function () {
    const moreContent = document.getElementById("moreContent");
    const shortBio = document.getElementById("shortBio");

    if (moreContent.style.maxHeight === "0px" || moreContent.style.maxHeight === "") {
        moreContent.style.maxHeight = "600px"; // enough height for long bio
        shortBio.style.display = "none";
        this.textContent = "SHOW LESS ↑";
    } else {
        moreContent.style.maxHeight = "0px";
        shortBio.style.display = "block";
        this.textContent = "READ MORE →";
    }
});


</script>


@include('layouts.footer')
