@if(!Auth::check())
<div class="modal fade" id="forgetPasswordModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content shadow-lg border-0">

      <!-- Header -->
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Forgot Password</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <!-- Body -->
      <div class="modal-body p-4">

        @if($errors->any())
          <div class="alert alert-danger">
            @foreach($errors->all() as $error)
              <div>{{ $error }}</div>
            @endforeach
          </div>
        @endif

        @if(session('success'))
          <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        @if(session('error'))
          <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <form action="{{ route('forget_password_submit') }}" method="POST">
          @csrf

          <div class="mb-3">
            <label class="form-label">Email address</label>
            <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
          </div>

          <button type="submit" class="btn btn-warning w-100">
            Send Reset Link
          </button>
        </form>

        <div class="text-center mt-3">
          <a href="javascript:void(0)"
             data-bs-dismiss="modal"
             data-bs-toggle="modal"
             data-bs-target="#loginModal">
            Back to Login
          </a>
        </div>

      </div>

    </div>
  </div>
</div>
@endif
