@if(Auth::check())
<div class="modal fade" id="profileEditModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable">
    <div class="modal-content">

      <!-- HEADER -->
      <div class="modal-header">
        <h5 class="modal-title">
          <i class="fa fa-user me-2"></i> My Profile
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <!-- BODY -->
      <div class="modal-body">

        {{-- Alerts --}}
        @if($errors->any())
          <div class="alert alert-danger">
            @foreach($errors->all() as $error)
              <div>{{ $error }}</div>
            @endforeach
          </div>
        @endif

        @if(session('success'))
          <div class="alert alert-success">
            {{ session('success') }}
          </div>
        @endif

        @if(session('error'))
          <div class="alert alert-danger">
            {{ session('error') }}
          </div>
        @endif

        <form action="{{ route('profile_submit') }}" method="post" enctype="multipart/form-data">
          @csrf

          <!-- PHOTO -->
          <div class="mb-4 text-center">
            @if(Auth::user()->photo)
              <img src="{{ asset('uploads/users/'.Auth::user()->photo) }}"
                   class="rounded-circle mb-2"
                   style="width:120px;height:120px;object-fit:cover;">
            @else
              <div class="text-muted">No photo uploaded</div>
            @endif

            <input type="file" name="photo" class="form-control mt-2">
          </div>

          <!-- BASIC INFO -->
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Name</label>
              <input type="text" name="name" class="form-control"
                     value="{{ Auth::user()->name }}">
            </div>

            <div class="col-md-6">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control"
                     value="{{ Auth::user()->email }}">
            </div>

            <div class="col-md-6">
              <label class="form-label">Phone</label>
              <input type="text" name="phone" class="form-control"
                     value="{{ Auth::user()->phone }}">
            </div>

            <div class="col-md-6">
              <label class="form-label">Address</label>
              <input type="text" name="address" class="form-control"
                     value="{{ Auth::user()->address }}">
            </div>

            <div class="col-md-4">
              <label class="form-label">Country</label>
              <input type="text" name="country" class="form-control"
                     value="{{ Auth::user()->country }}">
            </div>

            <div class="col-md-4">
              <label class="form-label">State</label>
              <input type="text" name="state" class="form-control"
                     value="{{ Auth::user()->state }}">
            </div>

            <div class="col-md-4">
              <label class="form-label">City</label>
              <input type="text" name="city" class="form-control"
                     value="{{ Auth::user()->city }}">
            </div>

            <div class="col-md-4">
              <label class="form-label">Zip Code</label>
              <input type="text" name="zip" class="form-control"
                     value="{{ Auth::user()->zip }}">
            </div>
          </div>

          <!-- PASSWORD -->
          <hr class="my-4">

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">New Password</label>
              <input type="password" name="password" class="form-control">
            </div>

            <div class="col-md-6">
              <label class="form-label">Confirm Password</label>
              <input type="password" name="confirm_password" class="form-control">
            </div>
          </div>

          <!-- SUBMIT -->
          <div class="text-end mt-4">
            <button type="submit" class="btn btn-warning btn-lg">
              Update Profile
            </button>
          </div>

        </form>
      </div>

    </div>
  </div>
</div>
@endif
