

<div class="container d-flex justify-content-center align-items-center" style="min-height:70vh;">
  <div class="card shadow-lg border-0" style="max-width:420px; width:100%; border-radius:16px;">

    <!-- Header -->
    <div class="card-header text-center text-white"
         style="background:#4b2e2a; border-radius:16px 16px 0 0;">
      <h4 class="mb-0">Reset Your Password</h4>
      <small>Choose a strong new password</small>
    </div>

    <!-- Body -->
    <div class="card-body p-4">

      {{-- Errors --}}
      @if($errors->any())
        <div class="alert alert-danger">
          @foreach($errors->all() as $error)
            <div>{{ $error }}</div>
          @endforeach
        </div>
      @endif

      {{-- Success --}}
      @if(session('success'))
        <div class="alert alert-success">
          {{ session('success') }}
        </div>
      @endif

      {{-- Error --}}
      @if(session('error'))
        <div class="alert alert-danger">
          {{ session('error') }}
        </div>
      @endif

      <form action="{{ route('reset_password_submit', [$token, $email]) }}" method="POST">
        @csrf

        <div class="mb-3">
          <label class="form-label fw-semibold">New Password</label>
          <input type="password"
                 name="password"
                 class="form-control form-control-lg"
                 placeholder="Enter new password"
                 required>
        </div>

        <div class="mb-4">
          <label class="form-label fw-semibold">Confirm Password</label>
          <input type="password"
                 name="confirm_password"
                 class="form-control form-control-lg"
                 placeholder="Re-enter password"
                 required>
        </div>

        <button type="submit"
                class="btn btn-warning w-100 btn-lg fw-semibold">
          Update Password
        </button>
      </form>

    </div>

    <!-- Footer -->
    <div class="card-footer text-center bg-white border-0 pb-3">
      <small class="text-muted">
        After reset, you can log in with your new password
      </small>
    </div>

  </div>
</div>
